/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke;

import com.oneeyedmen.okeydoke.Reporter;
import com.oneeyedmen.okeydoke.internal.OperatingSystem;
import com.oneeyedmen.okeydoke.reporters.CommandLineReporter;
import com.oneeyedmen.okeydoke.reporters.PopupReporter;
import java.io.File;

public abstract class Reporters {
    public static final String DIFFER_PROPERTY_NAME = "okeydoke.differ";
    public static final String POPUP_PROPERTY_NAME = "okeydoke.popup";

    public static Reporter<File, File> fileSystemReporter() {
        return Reporters.popup() ? new PopupReporter(Reporters.differ()) : new CommandLineReporter(Reporters.differ());
    }

    private static boolean popup() {
        String propertyValue = System.getProperty(POPUP_PROPERTY_NAME, "false");
        return propertyValue.equals("") ? true : Boolean.valueOf(propertyValue);
    }

    private static String differ() {
        String override = System.getProperty(DIFFER_PROPERTY_NAME);
        return override != null ? override : Reporters.differFor(OperatingSystem.current());
    }

    public static String differFor(OperatingSystem os) {
        switch (os) {
            case LINUX: {
                return "bcompare";
            }
            case MAC: {
                return "opendiff";
            }
        }
        return "diff";
    }
}

