/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke;

import com.oneeyedmen.okeydoke.Formatter;
import com.oneeyedmen.okeydoke.Transcript;
import java.io.PrintStream;

public class StandardTranscript
implements Transcript {
    private final PrintStream stream;
    private final Formatter<Object, String> formatter;
    private final String lineSeparator;
    private boolean isStartOfLine = true;

    public StandardTranscript(PrintStream stream, Formatter<Object, String> formatter) {
        this(stream, formatter, "\n");
    }

    public StandardTranscript(PrintStream stream, Formatter<Object, String> formatter, String lineSeparator) {
        this.stream = stream;
        this.formatter = formatter;
        this.lineSeparator = lineSeparator;
    }

    @Override
    public boolean isStartOfLine() {
        return this.isStartOfLine;
    }

    @Override
    public Transcript appendLine(String s) {
        this.stream.print(s);
        this.endl();
        this.isStartOfLine = true;
        return this;
    }

    @Override
    public Transcript append(String s) {
        this.stream.append(s);
        this.isStartOfLine = s.endsWith(this.lineSeparator);
        return this;
    }

    @Override
    public Transcript appendFormatted(Object o) {
        this.appendFormatted(o, this.formatter);
        return this;
    }

    @Override
    public <T> Transcript appendFormatted(T o, Formatter<T, String> aFormatter) {
        this.append(aFormatter.formatted(o));
        return this;
    }

    @Override
    public Transcript endl() {
        this.stream.print(this.lineSeparator);
        this.isStartOfLine = true;
        return this;
    }

    @Override
    public Transcript space() {
        return this.append(" ");
    }

    @Override
    public Transcript space(int number) {
        for (int i = 0; i < number; ++i) {
            this.space();
        }
        return this;
    }
}

