/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke.formatters;

import com.oneeyedmen.okeydoke.Formatter;
import java.util.Arrays;

public class StringFormatter
implements Formatter<Object, String> {
    private static final int BUFFER_SIZE = 4096;
    private final String quoteChar;

    public StringFormatter(String quoteChar) {
        this.quoteChar = quoteChar;
    }

    @Override
    public String formatted(Object actual) {
        if (actual == null) {
            return this.representationOfNull();
        }
        if (actual.getClass().isArray()) {
            return this.stringFor((Object[])actual);
        }
        if (actual instanceof Iterable) {
            return this.stringFor((Iterable)actual);
        }
        return String.valueOf(actual);
    }

    protected String representationOfNull() {
        return "NULL";
    }

    protected String stringFor(Iterable iterable) {
        StringBuilder result = new StringBuilder("[");
        for (Object o : iterable) {
            result.append(this.quoteChar).append(this.formatted(o)).append(this.quoteChar + ",");
        }
        if (result.length() > 1) {
            result.deleteCharAt(result.length() - 1);
        }
        result.append("]");
        return result.toString();
    }

    protected String stringFor(Object[] iterable) {
        return this.stringFor(Arrays.asList(iterable));
    }
}

