/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke.internal;

public class HexDump {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String format(byte[] bytes) {
        return HexDump.format(bytes, true, false);
    }

    public static String formatCompact(byte[] bytes) {
        return HexDump.format(bytes, false, false);
    }

    public static String format(byte[] bytes, boolean spaces, boolean Oxs) {
        StringBuilder result = new StringBuilder();
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            if (spaces && i != 0) {
                result.append(' ');
            }
            result.append(HexDump.format(bytes[i], Oxs));
        }
        return result.toString();
    }

    public static String format(byte aByte, boolean Ox) {
        char top = DIGITS[aByte >> 4 & 0xF];
        char bottom = DIGITS[aByte & 0xF];
        return (Ox ? "0x" : "") + top + bottom;
    }

    public static String format(byte aByte) {
        return HexDump.format(aByte, false);
    }

    public static byte[] readCompact(String hexString) {
        if (hexString.length() % 2 != 0) {
            throw new NumberFormatException("Hex string " + hexString + " has odd character");
        }
        int resultLength = hexString.length() / 2;
        byte[] result = new byte[resultLength];
        for (int i = 0; i < resultLength; ++i) {
            String pair = hexString.substring(2 * i, 2 * i + 2);
            result[i] = (byte)Short.parseShort(pair, 16);
        }
        return result;
    }
}

