/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke.internal;

public enum OperatingSystem {
    WINDOWS("Windows", "(?i).*win.*"),
    LINUX("Linux", "(?i).*lin.*"),
    MAC("MacOS", "(?i).*mac.*");

    private static final OperatingSystem current;
    private final String name;
    private final String regexp;

    private OperatingSystem(String name, String regexp) {
        this.name = name;
        this.regexp = regexp;
    }

    public static OperatingSystem current() {
        return current;
    }

    public static OperatingSystem fromString(String propertyValue) {
        for (OperatingSystem os : OperatingSystem.values()) {
            if (!propertyValue.matches(os.regexp)) continue;
            return os;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isMyOS() {
        return OperatingSystem.is(this);
    }

    public static boolean is(OperatingSystem os) {
        return OperatingSystem.current() == os;
    }

    public static boolean isnt(OperatingSystem os) {
        return !OperatingSystem.is(os);
    }

    static {
        current = OperatingSystem.fromString(System.getProperty("os.name"));
    }
}

