/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke.junit4;

import com.oneeyedmen.okeydoke.ApproverFactory;
import com.oneeyedmen.okeydoke.BaseApprover;
import com.oneeyedmen.okeydoke.Formatter;
import com.oneeyedmen.okeydoke.junit4.StandardTestNamer;
import com.oneeyedmen.okeydoke.junit4.TestNamer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class BaseApprovalsRule<ApprovedT, ComparedT, ApproverT extends BaseApprover<ApprovedT, ComparedT>>
extends TestWatcher {
    private final ApproverFactory<ApproverT> factory;
    private final TestNamer testNamer;
    private ApproverT approver;

    public BaseApprovalsRule(ApproverFactory<ApproverT> factory) {
        this(factory, new StandardTestNamer());
    }

    public BaseApprovalsRule(ApproverFactory<ApproverT> factory, TestNamer testNamer) {
        this.factory = factory;
        this.testNamer = testNamer;
    }

    public PrintStream printStream() {
        return ((BaseApprover)this.approver()).printStream();
    }

    public OutputStream outputStream() throws IOException {
        return ((BaseApprover)this.approver).outputStream();
    }

    public void writeFormatted(ApprovedT o) {
        ((BaseApprover)this.approver()).writeFormatted(o);
    }

    public void assertApproved(ApprovedT actual) {
        ((BaseApprover)this.approver()).assertApproved(actual);
    }

    public <T2 extends ApprovedT> void assertApproved(T2 actual, Formatter<T2, ComparedT> formatter) {
        ((BaseApprover)this.approver()).assertApproved(actual, formatter);
    }

    public void assertSatisfied() {
        if (((BaseApprover)this.approver()).satisfactionChecked()) {
            throw new IllegalStateException("I've got too much satisfaction");
        }
        ((BaseApprover)this.approver()).assertSatisfied();
    }

    public void makeApproved(ApprovedT approved) throws IOException {
        ((BaseApprover)this.approver()).makeApproved(approved);
    }

    public void starting(Description description) {
        this.approver = this.createApprover(this.testNamer.nameFor(description), description.getTestClass());
    }

    public void succeeded(Description description) {
        if (((BaseApprover)this.approver()).satisfactionChecked()) {
            return;
        }
        this.assertSatisfied();
    }

    protected ApproverT createApprover(String testName, Class<?> testClass) {
        return this.factory.createApprover(testName, testClass);
    }

    public ApproverT approver() {
        this.checkRuleState();
        return this.approver;
    }

    protected void checkRuleState() {
        if (this.approver == null) {
            throw new IllegalStateException("Something is wrong - check your " + ((Object)((Object)this)).getClass().getSimpleName() + " is an @Rule field");
        }
    }

    public void removeApproved() throws IOException {
        ((BaseApprover)this.approver()).removeApproved();
    }
}

