/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke.junit4;

import com.oneeyedmen.okeydoke.Name;
import com.oneeyedmen.okeydoke.junit4.TestNamer;
import java.lang.reflect.Method;
import org.junit.runner.Description;

public class StandardTestNamer
implements TestNamer {
    @Override
    public String nameFor(Description description) {
        return this.nameFromClass(description) + this.suffixFromMethod(description);
    }

    private String suffixFromMethod(Description description) {
        String override = this.nameFromMethodAnnotation(description);
        if (override != null) {
            return "." + override;
        }
        String methodNameFromDescription = description.getMethodName();
        return methodNameFromDescription == null ? "" : "." + methodNameFromDescription;
    }

    private String nameFromMethodAnnotation(Description description) {
        Method method = this.methodFrom(description);
        if (method == null) {
            return null;
        }
        Name annotation = method.getAnnotation(Name.class);
        return annotation == null ? null : annotation.value();
    }

    private Method methodFrom(Description description) {
        Class testClass = description.getTestClass();
        String methodName = description.getMethodName();
        if (testClass == null || methodName == null) {
            return null;
        }
        try {
            return testClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private String nameFromClass(Description description) {
        Class testClass = description.getTestClass();
        if (testClass == null) {
            return description.getClassName();
        }
        Name annotation = testClass.getAnnotation(Name.class);
        return annotation == null ? testClass.getSimpleName() : annotation.value();
    }
}

