/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke.junit4;

import com.oneeyedmen.okeydoke.Approver;
import com.oneeyedmen.okeydoke.ApproverFactories;
import com.oneeyedmen.okeydoke.ApproverFactory;
import com.oneeyedmen.okeydoke.Formatter;
import com.oneeyedmen.okeydoke.Formatters;
import com.oneeyedmen.okeydoke.Invocation;
import com.oneeyedmen.okeydoke.formatters.InvocationFormatter;
import com.oneeyedmen.okeydoke.internal.Fred;
import com.oneeyedmen.okeydoke.internal.MethodFinder;
import com.oneeyedmen.okeydoke.junit4.StandardTestNamer;
import com.oneeyedmen.okeydoke.junit4.TestNamer;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class TheoryApprovalsRule
extends TestWatcher {
    private final MethodFinder methodFinder = new MethodFinder();
    private final Map<Description, Approver> approvers = new HashMap<Description, Approver>();
    private final ApproverFactory<Approver> factory;
    private final TestNamer testNamer;
    private Description description;

    public static TheoryApprovalsRule fileSystemRule(File sourceRoot) {
        return new TheoryApprovalsRule(ApproverFactories.fileSystemApproverFactory(sourceRoot));
    }

    public static TheoryApprovalsRule fileSystemRule(String sourceRoot) {
        return TheoryApprovalsRule.fileSystemRule(new File(sourceRoot));
    }

    public TheoryApprovalsRule(ApproverFactory factory) {
        this(factory, new StandardTestNamer());
    }

    public TheoryApprovalsRule(ApproverFactory factory, TestNamer testNamer) {
        this.factory = factory;
        this.testNamer = testNamer;
    }

    public TheoryApprover approver() {
        return new TheoryApprover();
    }

    public void starting(Description description) {
        this.description = description;
    }

    protected void succeeded(Description description) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (Approver approver : this.approvers.values()) {
            try {
                approver.assertSatisfied();
            }
            catch (Throwable t) {
                errors.add(t);
            }
        }
        if (!errors.isEmpty()) {
            this.rethrow((Throwable)errors.get(0));
        }
    }

    private void rethrow(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public class TheoryApprover
    extends TestWatcher {
        private Description theory;
        private Formatter<Invocation, String> invocationFormatter = Formatters.invocationFormatter();

        public TheoryApprover withInvocationFormatter(InvocationFormatter invocationFormatter) {
            this.invocationFormatter = invocationFormatter;
            return this;
        }

        public void starting(Description description) {
            this.theory = description;
            if (!TheoryApprovalsRule.this.approvers.containsKey(description)) {
                TheoryApprovalsRule.this.approvers.put(this.theory, TheoryApprovalsRule.this.factory.createApprover(TheoryApprovalsRule.this.testNamer.nameFor(description), TheoryApprovalsRule.this.description.getTestClass()));
            }
            super.starting(description);
        }

        public void lockDownResult(Object result, Object ... arguments) {
            Invocation invocation = new Invocation(arguments, result);
            this.lockDownResult(invocation);
        }

        public void lockDownResult(Invocation invocation) {
            Approver approver = (Approver)TheoryApprovalsRule.this.approvers.get(this.theory);
            if (approver == null) {
                throw new IllegalStateException("Something is wrong - check that I am an @Rule!");
            }
            approver.transcript().appendFormatted(invocation, this.invocationFormatter).endl();
        }

        public void lockDownReflectively(Object object, String methodName, Object ... arguments) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
            List<Method> methods = TheoryApprovalsRule.this.methodFinder.findMethods(TheoryApprovalsRule.this.methodFinder.classFor(object), methodName, arguments);
            for (Method method : methods) {
                try {
                    this.lockDownResult(new Invocation(object, method, arguments));
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            throw new NoSuchMethodException(methodName);
        }

        public <T> T lockDown(final T object) {
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object result = method.invoke(object, args);
                    TheoryApprover.this.lockDownResult(result, args);
                    return result;
                }
            };
            return (T)Fred.newProxyInstance(object.getClass(), handler);
        }
    }
}

