/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke.junit5;

import com.oneeyedmen.okeydoke.Approver;
import com.oneeyedmen.okeydoke.ApproverFactories;
import com.oneeyedmen.okeydoke.ApproverFactory;
import com.oneeyedmen.okeydoke.Name;
import com.oneeyedmen.okeydoke.internal.DirectoryFinder;
import java.io.File;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class ApprovalsExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback,
ParameterResolver {
    private static final String STORE_KEY = "okeydoke.approver";
    private final ApproverFactory<Approver> factory;
    private final TestNamer testNamer = new TestNamer();

    public ApprovalsExtension(ApproverFactory<Approver> factory) {
        this.factory = factory;
    }

    public ApprovalsExtension(File sourceRoot) {
        this(ApproverFactories.fileSystemApproverFactory(sourceRoot));
    }

    public ApprovalsExtension(File sourceRoot, String extension) {
        this(ApproverFactories.fileSystemApproverFactory(sourceRoot, extension));
    }

    public ApprovalsExtension(String extension) {
        this(ApproverFactories.fileSystemApproverFactory(DirectoryFinder.findARootDirectory(), extension));
    }

    public ApprovalsExtension() {
        this(DirectoryFinder.findARootDirectory());
    }

    public void beforeTestExecution(ExtensionContext context) {
        this.store(context).put((Object)STORE_KEY, (Object)this.factory.createApprover(this.testNamer.nameFor(context.getRequiredTestClass(), context.getRequiredTestMethod()), context.getRequiredTestClass()));
    }

    public void afterTestExecution(ExtensionContext context) {
        Approver approver;
        if (!context.getExecutionException().isPresent() && !(approver = (Approver)this.store(context).get((Object)STORE_KEY)).satisfactionChecked()) {
            approver.assertSatisfied();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return Approver.class.equals(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (Approver.class.equals(parameterContext.getParameter().getType())) {
            return this.store(extensionContext).get((Object)STORE_KEY);
        }
        return null;
    }

    private ExtensionContext.Store store(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{context.getRequiredTestClass().getName(), context.getRequiredTestMethod().getName()}));
    }

    private static class TestNamer {
        private TestNamer() {
        }

        public String nameFor(Class<?> testClass, Method testMethod) {
            return this.nameFromClass(testClass) + "." + this.nameFromMethod(testMethod);
        }

        private String nameFromMethod(Method testMethod) {
            Name nameAnnotation = testMethod.getAnnotation(Name.class);
            if (nameAnnotation != null) {
                return nameAnnotation.value();
            }
            return testMethod.getName();
        }

        private String nameFromClass(Class<?> testClass) {
            Name nameAnnotation = testClass.getAnnotation(Name.class);
            if (nameAnnotation != null) {
                return nameAnnotation.value();
            }
            return testClass.getSimpleName();
        }
    }
}

