/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke.serializers;

import com.oneeyedmen.okeydoke.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;

public class StringSerializer
implements Serializer<String> {
    private static final int BUFFER_SIZE = 4096;
    private final Charset charset;

    public StringSerializer(Charset charset) {
        this.charset = charset;
    }

    @Override
    public String readFrom(InputStream is) throws IOException {
        return StringSerializer.readFully(new InputStreamReader(is, this.charset));
    }

    @Override
    public String emptyThing() {
        return "";
    }

    @Override
    public void writeTo(String s, OutputStream os) throws IOException {
        os.write(s.getBytes(this.charset));
    }

    public Charset getCharset() {
        return this.charset;
    }

    private static String readFully(Reader input) throws IOException {
        int charsRead;
        StringBuilder result = new StringBuilder();
        char[] buffer = new char[4096];
        while ((charsRead = input.read(buffer)) != -1) {
            result.append(buffer, 0, charsRead);
        }
        return result.toString();
    }
}

