/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke.sources;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ComparingOutputStream
extends FilterOutputStream {
    private final InputStream is;
    private long position = -1L;
    private long firstMismatchPosition = -1L;

    public ComparingOutputStream(OutputStream out, InputStream is) {
        super(out);
        this.is = is;
    }

    @Override
    public void write(int b) throws IOException {
        int read;
        ++this.position;
        if (this.firstMismatchPosition == -1L && b != (read = this.is.read())) {
            this.firstMismatchPosition = this.position;
        }
        super.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.firstMismatchPosition == -1L) {
            for (int i = off; i < len; ++i) {
                this.write(b[i]);
            }
        } else {
            super.write(b, off, len);
        }
    }

    @Override
    public void close() throws IOException {
        this.is.close();
        super.close();
    }

    public void assertNoMismatch() throws AssertionError {
        if (this.firstMismatchPosition != -1L) {
            throw new AssertionError((Object)("Streams differed at " + this.firstMismatchPosition));
        }
    }
}

