/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke.sources;

import com.oneeyedmen.okeydoke.Resource;
import com.oneeyedmen.okeydoke.sources.LazyOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileResource
implements Resource {
    private final File file;
    private OutputStream os;

    public FileResource(File file) {
        this.file = file;
    }

    @Override
    public OutputStream outputStream() throws IOException {
        if (this.os == null) {
            this.os = this.outputStreamFor(this.file);
        }
        return this.os;
    }

    @Override
    public InputStream inputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public void remove() throws IOException {
        this.file.delete();
        if (this.exists()) {
            throw new IOException("Failed to delete " + this.file);
        }
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public long size() {
        return this.file.length();
    }

    public File file() {
        return this.file;
    }

    protected OutputStream outputStreamFor(final File file) throws IOException {
        return new LazyOutputStream(){

            @Override
            protected OutputStream createOut() throws IOException {
                file.getParentFile().mkdirs();
                return new BufferedOutputStream(new FileOutputStream(file));
            }
        };
    }
}

