/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke.sources;

import com.oneeyedmen.okeydoke.Checker;
import com.oneeyedmen.okeydoke.Reporter;
import com.oneeyedmen.okeydoke.Resource;
import com.oneeyedmen.okeydoke.Serializer;
import com.oneeyedmen.okeydoke.SourceOfApproval;
import com.oneeyedmen.okeydoke.internal.IO;
import com.oneeyedmen.okeydoke.sources.FileResource;
import java.io.File;
import java.io.IOException;

public class FileSystemSourceOfApproval
implements SourceOfApproval {
    private final Reporter<File, File> reporter;
    private final File approvedDir;
    private final File actualDir;
    private final String typeExtension;

    public FileSystemSourceOfApproval(File approvedDir, File actualDir, String typeExtension, Reporter<File, File> reporter) {
        this.approvedDir = approvedDir;
        this.actualDir = actualDir;
        this.typeExtension = typeExtension;
        this.reporter = reporter;
    }

    public FileSystemSourceOfApproval(File approvedDir, File actualDir, Reporter<File, File> reporter) {
        this(approvedDir, actualDir, "", reporter);
    }

    public FileSystemSourceOfApproval(File directory, Reporter<File, File> reporter) {
        this(directory, directory, reporter);
    }

    public FileSystemSourceOfApproval withActualDirectory(File actualDirectory) {
        return new FileSystemSourceOfApproval(this.approvedDir, actualDirectory, this.typeExtension, this.reporter);
    }

    public FileSystemSourceOfApproval withTypeExtension(String typeExtension) {
        return new FileSystemSourceOfApproval(this.approvedDir, this.actualDir, typeExtension, this.reporter);
    }

    @Override
    public Resource actualFor(String testName) {
        return new FileResource(this.actualFileFor(testName));
    }

    @Override
    public Resource approvedFor(String testName) {
        return new FileResource(this.approvedFileFor(testName));
    }

    @Override
    public void reportFailure(String testName, AssertionError e) {
        this.reporter.reportFailure(this.actualFileFor(testName), this.approvedFileFor(testName), (Throwable)((Object)e));
    }

    @Override
    public <T> void checkActualAgainstApproved(String testName, Serializer<T> serializer, Checker<T> checker) throws IOException {
        checker.assertEquals(IO.readResource(this.approvedFor(testName), serializer), IO.readResource(this.actualFor(testName), serializer));
    }

    protected File approvedFileFor(String testName) {
        return new File(this.approvedDir, testName + this.approvedExtension());
    }

    protected File actualFileFor(String testName) {
        return new File(this.actualDir, testName + this.actualExtension());
    }

    private String approvedExtension() {
        return ".approved" + this.typeExtension();
    }

    protected String actualExtension() {
        return ".actual" + this.typeExtension();
    }

    private String typeExtension() {
        return this.typeExtension;
    }
}

