/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke.sources;

import java.io.IOException;
import java.io.OutputStream;

public abstract class LazyOutputStream
extends OutputStream {
    private OutputStream _out = null;

    protected abstract OutputStream createOut() throws IOException;

    private OutputStream out() throws IOException {
        if (this._out == null) {
            this._out = this.createOut();
        }
        return this._out;
    }

    @Override
    public void write(int b) throws IOException {
        this.out().write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this._out == null) {
            return;
        }
        this.out().flush();
    }

    @Override
    public void close() throws IOException {
        if (this._out == null) {
            return;
        }
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out().close();
    }
}

