/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke.sources;

import com.oneeyedmen.okeydoke.Checker;
import com.oneeyedmen.okeydoke.Reporter;
import com.oneeyedmen.okeydoke.Resource;
import com.oneeyedmen.okeydoke.Serializer;
import com.oneeyedmen.okeydoke.sources.ComparingOutputStream;
import com.oneeyedmen.okeydoke.sources.FileResource;
import com.oneeyedmen.okeydoke.sources.FileSystemSourceOfApproval;
import com.oneeyedmen.okeydoke.sources.StreamingFileResource;
import java.io.File;
import java.io.IOException;

public class StreamingFileSystemSourceOfApproval
extends FileSystemSourceOfApproval {
    public StreamingFileSystemSourceOfApproval(File directory, Reporter<File, File> reporter) {
        super(directory, reporter);
    }

    @Override
    public Resource actualFor(String testname) {
        File file = this.approvedFileFor(testname);
        return file.exists() && file.isFile() ? new StreamingFileResource(this.actualFileFor(testname), new FileResource(this.approvedFileFor(testname))) : new FileResource(this.actualFileFor(testname));
    }

    @Override
    public <T> void checkActualAgainstApproved(String testName, Serializer<T> serializer, Checker<T> checker) throws IOException {
        Resource actual = this.actualFor(testName);
        if (actual instanceof StreamingFileResource) {
            ((ComparingOutputStream)actual.outputStream()).assertNoMismatch();
        } else {
            super.checkActualAgainstApproved(testName, serializer, checker);
        }
    }
}

