/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke.util;

import com.oneeyedmen.okeydoke.internal.LyingWrappingIterator;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Tabulator {
    public String tableOf(Iterable<?> data) {
        return this.tableOf(data, this.columnSizes(data));
    }

    public String headedTableOf(Iterable<?> data, String ... headers) {
        Iterable<?> dataWithHeader = this.withHeader(data, headers);
        int[] columnSizes = this.columnSizes(dataWithHeader);
        return this.tableOf(this.withDivider(dataWithHeader, columnSizes), columnSizes);
    }

    private int[] columnSizes(Iterable<?> data) {
        int[] result = new int[]{};
        for (Object row : data) {
            Collection<?> rowCollection = this.collectionOf(row);
            if (result.length == 0) {
                result = new int[rowCollection.size()];
            }
            int c = 0;
            for (Object cell : rowCollection) {
                int cellLength = String.valueOf(cell).length();
                result[c] = Math.max(result[c], cellLength);
                ++c;
            }
        }
        return result;
    }

    private Collection<?> collectionOf(Object row) {
        if (row instanceof Collection) {
            return (Collection)row;
        }
        if (row.getClass().isArray()) {
            return Tabulator.asList(row);
        }
        return Collections.singleton(row);
    }

    private String tableOf(Iterable<?> data, int[] columnSizes) {
        if (columnSizes.length == 0) {
            return "";
        }
        List<List<String>> formatted = this.formattedCells(data, columnSizes);
        StringBuffer result = new StringBuffer();
        for (List<String> row : formatted) {
            this.formatRowInto(result, row);
        }
        return result.toString();
    }

    private void formatRowInto(StringBuffer result, List<String> row) {
        result.append('|');
        for (String cell : row) {
            result.append(cell).append('|');
        }
        result.append('\n');
    }

    private List<List<String>> formattedCells(Iterable<?> data, int[] columnSizes) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (Object row : data) {
            result.add(this.formattedRow(this.collectionOf(row), columnSizes));
        }
        return result;
    }

    private List<String> formattedRow(Iterable<?> rowCollection, int[] columnSizes) {
        ArrayList<String> resultRow = new ArrayList<String>();
        int c = 0;
        for (Object cell : rowCollection) {
            resultRow.add(this.formatCell(String.valueOf(cell), columnSizes[c]));
            ++c;
        }
        return resultRow;
    }

    private String formatCell(String s, int columnSize) {
        if (s.length() == columnSize) {
            return s;
        }
        StringBuilder result = new StringBuilder(columnSize);
        result.append(s);
        while (result.length() < columnSize) {
            result.append(' ');
        }
        return result.toString();
    }

    public static <T> List<T> asList(final Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array");
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return Array.get(array, index);
            }

            @Override
            public int size() {
                return Array.getLength(array);
            }
        };
    }

    private Iterable<?> withHeader(final Iterable<?> data, final String ... headers) {
        return new Iterable(){

            public Iterator iterator() {
                return new LyingWrappingIterator(data.iterator()){

                    @Override
                    protected boolean hasNext(int i) {
                        return this.wrapped.hasNext() || i < 1;
                    }

                    protected Object next(int i) {
                        return i == 0 ? headers : this.wrapped.next();
                    }
                };
            }
        };
    }

    private Iterable<?> withDivider(final Iterable<?> data, final int[] columnSizes) {
        return new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new LyingWrappingIterator(data.iterator()){

                    @Override
                    protected boolean hasNext(int i) {
                        return this.wrapped.hasNext() || i < 2;
                    }

                    protected Object next(int i) {
                        return i == 1 ? Tabulator.this.dividerData(columnSizes) : this.wrapped.next();
                    }
                };
            }
        };
    }

    private Collection<?> dividerData(int[] columnSizes) {
        ArrayList<String> result = new ArrayList<String>(columnSizes.length);
        for (int i = 0; i < columnSizes.length; ++i) {
            result.add(this.times('-', columnSizes[i]));
        }
        return result;
    }

    private String times(char ch, int repeat) {
        StringBuffer result = new StringBuffer(repeat);
        for (int i = 0; i < repeat; ++i) {
            result.append(ch);
        }
        return result.toString();
    }
}

