/*
 * Decompiled with CFR 0.152.
 */
package com.oneeyedmen.okeydoke.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;

public class TestDirectory
extends File {
    public static final File BASE_DIR;

    public static TestDirectory empty(Object test) {
        return new TestDirectory(test);
    }

    public TestDirectory(String relativePath) {
        super(TestDirectory.fileFor(relativePath).toString());
        if (this.isFile()) {
            throw new RuntimeException(this + " is a file not a directory");
        }
        try {
            this.deleteWithRetry(this, 5);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mkdirs();
    }

    public TestDirectory(Class<?> testClass) {
        this(testClass.getName());
    }

    public TestDirectory(Object test) {
        this(test.toString());
    }

    public static void delete(File f) throws IOException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                TestDirectory.delete(c);
            }
        }
        if (!f.delete()) {
            throw new IOException("Failed to delete file: " + f);
        }
    }

    public File createFileFrom(String filename, String contents) throws IOException {
        File result = this.file(filename);
        result.getParentFile().mkdirs();
        BufferedWriter w = new BufferedWriter(new FileWriter(result));
        w.write(contents);
        w.close();
        return result;
    }

    public File touchFile(String filename) throws IOException {
        return this.touchFile(filename, 0L);
    }

    public File touchFile(String filename, long size) throws IOException {
        File result = this.file(filename);
        result.getParentFile().mkdirs();
        RandomAccessFile randomAccessFile = new RandomAccessFile(result, "rw");
        randomAccessFile.setLength(size);
        randomAccessFile.close();
        return result;
    }

    public File mkDirs(String path) throws IOException {
        File result = this.file(path);
        result.mkdirs();
        if (!result.isDirectory()) {
            throw new IOException("Could not create dir " + path);
        }
        return result;
    }

    public boolean hasFile(String filename) {
        return this.file(filename).isFile();
    }

    public File file(String filename) {
        return new File(this, filename);
    }

    public void remove() throws IOException {
        this.deleteWithRetry(this, 5);
    }

    private void deleteWithRetry(File file, int retryCount) throws IOException {
        if (!file.exists()) {
            return;
        }
        for (int i = 0; i < retryCount - 1 && !file.exists(); ++i) {
            try {
                TestDirectory.delete(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.gc();
        }
        TestDirectory.delete(file);
    }

    static File fileFor(String relativePath) {
        return new File(BASE_DIR, relativePath);
    }

    static {
        String tmpdir = System.getProperty("java.io.tmpdir");
        tmpdir = tmpdir == null ? "C:/temp" : tmpdir;
        try {
            BASE_DIR = new File(tmpdir).getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

