/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava;

import com.oneidentity.safeguard.safeguardjava.ISafeguardA2AContext;
import com.oneidentity.safeguard.safeguardjava.ISafeguardConnection;
import com.oneidentity.safeguard.safeguardjava.SafeguardA2AContext;
import com.oneidentity.safeguard.safeguardjava.SafeguardConnection;
import com.oneidentity.safeguard.safeguardjava.authentication.AccessTokenAuthenticator;
import com.oneidentity.safeguard.safeguardjava.authentication.AnonymousAuthenticator;
import com.oneidentity.safeguard.safeguardjava.authentication.CertificateAuthenticator;
import com.oneidentity.safeguard.safeguardjava.authentication.IAuthenticationMechanism;
import com.oneidentity.safeguard.safeguardjava.authentication.PasswordAuthenticator;
import com.oneidentity.safeguard.safeguardjava.event.ISafeguardEventHandler;
import com.oneidentity.safeguard.safeguardjava.event.ISafeguardEventListener;
import com.oneidentity.safeguard.safeguardjava.event.PersistentSafeguardA2AEventListener;
import com.oneidentity.safeguard.safeguardjava.event.PersistentSafeguardEventListener;
import com.oneidentity.safeguard.safeguardjava.exceptions.ArgumentException;
import com.oneidentity.safeguard.safeguardjava.exceptions.ObjectDisposedException;
import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardForJavaException;
import java.util.List;

public final class Safeguard {
    private static final int DEFAULTAPIVERSION = 3;

    private Safeguard() {
    }

    private static SafeguardConnection getConnection(IAuthenticationMechanism authenticationMechanism) throws ObjectDisposedException, SafeguardForJavaException {
        authenticationMechanism.refreshAccessToken();
        return new SafeguardConnection(authenticationMechanism);
    }

    public static ISafeguardConnection connect(String networkAddress, char[] accessToken, Integer apiVersion, Boolean ignoreSsl) throws ArgumentException {
        int version = 3;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        return new SafeguardConnection(new AccessTokenAuthenticator(networkAddress, accessToken, version, sslIgnore));
    }

    public static ISafeguardConnection connect(String networkAddress, String provider, String username, char[] password, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, ArgumentException, SafeguardForJavaException {
        int version = 3;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        return Safeguard.getConnection(new PasswordAuthenticator(networkAddress, provider, username, password, version, sslIgnore));
    }

    public static ISafeguardConnection connect(String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 3;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, keystorePath, keystorePassword, certificateAlias, version, sslIgnore));
    }

    public static ISafeguardConnection connect(String networkAddress, String certificatePath, char[] certificatePassword, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
        int version = 3;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        return Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificatePath, certificatePassword, version, sslIgnore));
    }

    public static ISafeguardConnection connect(String networkAddress, Integer apiVersion, Boolean ignoreSsl) {
        int version = 3;
        if (apiVersion != null) {
            version = apiVersion;
        }
        boolean sslIgnore = false;
        if (ignoreSsl != null) {
            sslIgnore = ignoreSsl;
        }
        return new SafeguardConnection(new AnonymousAuthenticator(networkAddress, version, sslIgnore));
    }

    public static class A2A {
        public static ISafeguardA2AContext getContext(String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, Integer apiVersion, Boolean ignoreSsl) {
            int version = 3;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            return new SafeguardA2AContext(networkAddress, certificateAlias, keystorePath, keystorePassword, version, sslIgnore);
        }

        public static ISafeguardA2AContext getContext(String networkAddress, String certificatePath, char[] certificatePassword, Integer apiVersion, Boolean ignoreSsl) {
            int version = 3;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            return new SafeguardA2AContext(networkAddress, certificatePath, certificatePassword, version, sslIgnore);
        }

        public static class Event {
            public static ISafeguardEventListener getPersistentA2AEventListener(char[] apiKey, ISafeguardEventHandler handler, String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, ArgumentException {
                int version = 3;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                boolean sslIgnore = false;
                if (ignoreSsl != null) {
                    sslIgnore = ignoreSsl;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificateAlias, keystorePath, keystorePassword, version, ignoreSsl), apiKey, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(char[] apiKey, ISafeguardEventHandler handler, String networkAddress, String certificatePath, char[] certificatePassword, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, ArgumentException {
                int version = 3;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                boolean sslIgnore = false;
                if (ignoreSsl != null) {
                    sslIgnore = ignoreSsl;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificatePath, certificatePassword, version, ignoreSsl), apiKey, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(List<char[]> apiKeys, ISafeguardEventHandler handler, String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, ArgumentException {
                int version = 3;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                boolean sslIgnore = false;
                if (ignoreSsl != null) {
                    sslIgnore = ignoreSsl;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificateAlias, keystorePath, keystorePassword, version, ignoreSsl), apiKeys, handler);
            }

            public static ISafeguardEventListener getPersistentA2AEventListener(List<char[]> apiKeys, ISafeguardEventHandler handler, String networkAddress, String certificatePath, char[] certificatePassword, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, ArgumentException {
                int version = 3;
                if (apiVersion != null) {
                    version = apiVersion;
                }
                boolean sslIgnore = false;
                if (ignoreSsl != null) {
                    sslIgnore = ignoreSsl;
                }
                return new PersistentSafeguardA2AEventListener((ISafeguardA2AContext)new SafeguardA2AContext(networkAddress, certificatePath, certificatePassword, version, ignoreSsl), apiKeys, handler);
            }
        }
    }

    public static class Event {
        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String provider, String username, char[] password, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException, ArgumentException {
            int version = 3;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new PasswordAuthenticator(networkAddress, provider, username, password, version, ignoreSsl)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String certificatePath, char[] certificatePassword, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 3;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, certificatePath, certificatePassword, version, ignoreSsl)));
        }

        public static ISafeguardEventListener getPersistentEventListener(String networkAddress, String keystorePath, char[] keystorePassword, String certificateAlias, Integer apiVersion, Boolean ignoreSsl) throws ObjectDisposedException, SafeguardForJavaException {
            int version = 3;
            if (apiVersion != null) {
                version = apiVersion;
            }
            boolean sslIgnore = false;
            if (ignoreSsl != null) {
                sslIgnore = ignoreSsl;
            }
            return new PersistentSafeguardEventListener(Safeguard.getConnection(new CertificateAuthenticator(networkAddress, keystorePath, keystorePassword, certificateAlias, version, ignoreSsl)));
        }
    }
}

