/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava.authentication;

import com.oneidentity.safeguard.safeguardjava.Utils;
import com.oneidentity.safeguard.safeguardjava.authentication.IAuthenticationMechanism;
import com.oneidentity.safeguard.safeguardjava.data.AccessTokenBody;
import com.oneidentity.safeguard.safeguardjava.exceptions.ObjectDisposedException;
import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardForJavaException;
import com.oneidentity.safeguard.safeguardjava.restclient.RestClient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;

abstract class AuthenticatorBase
implements IAuthenticationMechanism {
    private boolean disposed;
    private final String networkAddress;
    private final int apiVersion;
    private boolean ignoreSsl;
    protected char[] accessToken;
    protected final String safeguardRstsUrl;
    protected final String safeguardCoreUrl;
    protected RestClient rstsClient;
    protected RestClient coreClient;

    protected AuthenticatorBase(String networkAddress, String certificatePath, char[] certificatePassword, int apiVersion, boolean ignoreSsl) {
        this.networkAddress = networkAddress;
        this.apiVersion = apiVersion;
        this.ignoreSsl = ignoreSsl;
        this.safeguardRstsUrl = String.format("https://%s/RSTS", this.networkAddress);
        this.rstsClient = new RestClient(this.safeguardRstsUrl, ignoreSsl);
        this.safeguardCoreUrl = String.format("https://%s/service/core/v%d", this.networkAddress, this.apiVersion);
        this.coreClient = new RestClient(this.safeguardCoreUrl, ignoreSsl);
    }

    @Override
    public abstract String getId();

    @Override
    public String getNetworkAddress() {
        return this.networkAddress;
    }

    @Override
    public int getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public boolean isIgnoreSsl() {
        return this.ignoreSsl;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean hasAccessToken() {
        return this.accessToken != null;
    }

    @Override
    public void clearAccessToken() {
        if (this.accessToken != null) {
            Arrays.fill(this.accessToken, '0');
        }
        this.accessToken = null;
    }

    @Override
    public char[] getAccessToken() throws ObjectDisposedException {
        if (this.disposed) {
            throw new ObjectDisposedException("AuthenticatorBase");
        }
        return this.accessToken;
    }

    @Override
    public int getAccessTokenLifetimeRemaining() throws ObjectDisposedException, SafeguardForJavaException {
        if (this.disposed) {
            throw new ObjectDisposedException("AuthenticatorBase");
        }
        if (!this.hasAccessToken()) {
            return 0;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", String.format("Bearer %s", new String(this.accessToken)));
        headers.put("X-TokenLifetimeRemaining", "");
        CloseableHttpResponse response = this.coreClient.execGET("LoginMessage", null, headers);
        if (response == null) {
            throw new SafeguardForJavaException(String.format("Unable to connect to web service %s", this.coreClient.getBaseURL()));
        }
        if (!Utils.isSuccessful(response.getStatusLine().getStatusCode())) {
            return 0;
        }
        String remainingStr = null;
        if (response.containsHeader("X-TokenLifetimeRemaining")) {
            remainingStr = response.getFirstHeader("X-TokenLifetimeRemaining").getValue();
        }
        int remaining = 10;
        if (remainingStr != null) {
            try {
                remaining = Integer.parseInt(remainingStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return remaining;
    }

    @Override
    public void refreshAccessToken() throws ObjectDisposedException, SafeguardForJavaException {
        if (this.disposed) {
            throw new ObjectDisposedException("AuthenticatorBase");
        }
        char[] rStsToken = this.getRstsTokenInternal();
        AccessTokenBody body = new AccessTokenBody(rStsToken);
        CloseableHttpResponse response = this.coreClient.execPOST("Token/LoginResponse", null, null, body);
        if (response == null) {
            throw new SafeguardForJavaException(String.format("Unable to connect to web service %s", this.coreClient.getBaseURL()));
        }
        String reply = Utils.getResponse(response);
        if (!Utils.isSuccessful(response.getStatusLine().getStatusCode())) {
            throw new SafeguardForJavaException("Error exchanging RSTS token from " + this.getId() + "authenticator for Safeguard API access token, Error: " + String.format("%d %s", response.getStatusLine().getStatusCode(), reply));
        }
        Map<String, String> map = Utils.parseResponse(reply);
        if (map.containsKey("UserToken")) {
            this.accessToken = map.get("UserToken").toCharArray();
        }
    }

    protected abstract char[] getRstsTokenInternal() throws ObjectDisposedException, SafeguardForJavaException;

    @Override
    public abstract Object cloneObject() throws SafeguardForJavaException;

    @Override
    public void dispose() {
        this.clearAccessToken();
        this.disposed = true;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.accessToken != null) {
                Arrays.fill(this.accessToken, '0');
            }
        }
        finally {
            this.disposed = true;
            super.finalize();
        }
    }
}

