/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava.authentication;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oneidentity.safeguard.safeguardjava.Utils;
import com.oneidentity.safeguard.safeguardjava.authentication.AuthenticatorBase;
import com.oneidentity.safeguard.safeguardjava.data.JsonBody;
import com.oneidentity.safeguard.safeguardjava.data.OauthBody;
import com.oneidentity.safeguard.safeguardjava.exceptions.ArgumentException;
import com.oneidentity.safeguard.safeguardjava.exceptions.ObjectDisposedException;
import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardForJavaException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.methods.CloseableHttpResponse;

public class PasswordAuthenticator
extends AuthenticatorBase {
    private boolean disposed;
    private final String provider;
    private String providerScope;
    private final String username;
    private final char[] password;

    public PasswordAuthenticator(String networkAddress, String provider, String username, char[] password, int apiVersion, boolean ignoreSsl) throws ArgumentException {
        super(networkAddress, null, null, apiVersion, ignoreSsl);
        this.provider = provider;
        if (Utils.isNullOrEmpty(this.provider) || this.provider.equalsIgnoreCase("local")) {
            this.providerScope = "rsts:sts:primaryproviderid:local";
        }
        this.username = username;
        if (password == null) {
            throw new ArgumentException("The password parameter can not be null");
        }
        this.password = (char[])password.clone();
    }

    @Override
    public String getId() {
        return "Password";
    }

    private void resolveProviderToScope() throws SafeguardForJavaException {
        block7: {
            try {
                HashMap<String, String> headers = new HashMap<String, String>();
                HashMap<String, String> parameters = new HashMap<String, String>();
                headers.clear();
                parameters.clear();
                headers.put("Content-type", "application/x-www-form-urlencoded");
                parameters.put("response_type", "token");
                parameters.put("redirect_uri", "urn:InstalledApplication");
                parameters.put("loginRequestStep", "1");
                CloseableHttpResponse response = this.rstsClient.execPOST("UserLogin/LoginController", parameters, headers, new JsonBody("RelayState="));
                if (response == null || !Utils.isSuccessful(response.getStatusLine().getStatusCode())) {
                    response = this.rstsClient.execGET("UserLogin/LoginController", parameters, headers);
                }
                if (response == null) {
                    throw new SafeguardForJavaException("Unable to connect to RSTS to find identity provider scopes");
                }
                String reply = Utils.getResponse(response);
                if (!Utils.isSuccessful(response.getStatusLine().getStatusCode())) {
                    throw new SafeguardForJavaException("Error requesting identity provider scopes from RSTS, Error: " + String.format("%d %s", response.getStatusLine().getStatusCode(), reply));
                }
                List<String> knownScopes = this.parseLoginResponse(reply);
                String scope = this.getMatchingScope(knownScopes, true);
                if (scope != null) {
                    this.providerScope = String.format("rsts:sts:primaryproviderid:%s", scope);
                    break block7;
                }
                scope = this.getMatchingScope(knownScopes, false);
                if (this.providerScope != null) {
                    this.providerScope = String.format("rsts:sts:primaryproviderid:%s", scope);
                    break block7;
                }
                throw new SafeguardForJavaException(String.format("Unable to find scope matching '%s' in [%s]", this.provider, String.join((CharSequence)",", knownScopes)));
            }
            catch (Exception ex) {
                throw new SafeguardForJavaException("Unable to connect to determine identity provider", ex);
            }
        }
    }

    @Override
    protected char[] getRstsTokenInternal() throws ObjectDisposedException, SafeguardForJavaException {
        OauthBody body;
        CloseableHttpResponse response;
        if (this.disposed) {
            throw new ObjectDisposedException("PasswordAuthenticator");
        }
        if (this.providerScope == null) {
            this.resolveProviderToScope();
        }
        if ((response = this.rstsClient.execPOST("oauth2/token", null, null, body = new OauthBody("password", this.username, this.password, this.providerScope))) == null) {
            throw new SafeguardForJavaException(String.format("Unable to connect to RSTS service %s", this.rstsClient.getBaseURL()));
        }
        String reply = Utils.getResponse(response);
        if (!Utils.isSuccessful(response.getStatusLine().getStatusCode())) {
            throw new SafeguardForJavaException(String.format("Error using password grant_type with scope %s, Error: ", this.providerScope) + String.format("%s %s", response.getStatusLine().getStatusCode(), reply));
        }
        Map<String, String> map = Utils.parseResponse(reply);
        if (!map.containsKey("access_token")) {
            throw new SafeguardForJavaException(String.format("Error retrieving the access key for scope: %s", this.providerScope));
        }
        return map.get("access_token").toCharArray();
    }

    @Override
    public Object cloneObject() throws SafeguardForJavaException {
        try {
            PasswordAuthenticator auth = new PasswordAuthenticator(this.getNetworkAddress(), this.provider, this.username, this.password, this.getApiVersion(), this.isIgnoreSsl());
            auth.accessToken = this.accessToken == null ? null : (char[])this.accessToken.clone();
            return auth;
        }
        catch (ArgumentException ex) {
            Logger.getLogger(PasswordAuthenticator.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.password != null) {
            Arrays.fill(this.password, '0');
        }
        this.disposed = true;
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            if (this.password != null) {
                Arrays.fill(this.password, '0');
            }
        }
        finally {
            this.disposed = true;
            super.finalize();
        }
    }

    private List<String> parseLoginResponse(String response) {
        ArrayList<String> providers = new ArrayList<String>();
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode jsonNodeRoot = mapper.readTree(response);
            JsonNode jsonNodeProviders = jsonNodeRoot.get("Providers");
            Iterator<JsonNode> iter = jsonNodeProviders.elements();
            while (iter.hasNext()) {
                JsonNode providerNode = iter.next();
                providers.add(this.getJsonValue(providerNode, "Id"));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return providers;
    }

    private String getMatchingScope(List<String> providers, boolean equals) {
        for (String s : providers) {
            if (!(equals ? s.equalsIgnoreCase(this.provider) : s.toLowerCase().contains(this.provider.toLowerCase()))) continue;
            return s;
        }
        return null;
    }

    private String getJsonValue(JsonNode node, String propName) {
        if (node.get(propName) != null) {
            return node.get(propName).asText();
        }
        return null;
    }
}

