/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava.event;

import com.oneidentity.safeguard.safeguardjava.ISafeguardConnection;
import com.oneidentity.safeguard.safeguardjava.event.PersistentSafeguardEventListenerBase;
import com.oneidentity.safeguard.safeguardjava.event.SafeguardEventListener;
import com.oneidentity.safeguard.safeguardjava.exceptions.ArgumentException;
import com.oneidentity.safeguard.safeguardjava.exceptions.ObjectDisposedException;
import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardForJavaException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PersistentSafeguardEventListener
extends PersistentSafeguardEventListenerBase {
    private boolean disposed;
    private final ISafeguardConnection connection;

    public PersistentSafeguardEventListener(ISafeguardConnection connection) {
        this.connection = connection;
        Logger.getLogger(PersistentSafeguardEventListener.class.getName()).log(Level.FINEST, "Persistent event listener successfully created.");
    }

    @Override
    public SafeguardEventListener reconnectEventListener() throws ObjectDisposedException, SafeguardForJavaException, ArgumentException {
        if (this.disposed) {
            throw new ObjectDisposedException("SafeguardEventListener");
        }
        if (this.connection.getAccessTokenLifetimeRemaining() == 0) {
            this.connection.refreshAccessToken();
        }
        return this.connection.getEventListener();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.connection != null) {
            this.connection.dispose();
        }
        this.disposed = true;
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            super.dispose();
            if (this.connection != null) {
                this.connection.dispose();
            }
        }
        finally {
            this.disposed = true;
            super.finalize();
        }
    }
}

