/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava.event;

import com.oneidentity.safeguard.safeguardjava.event.EventHandlerRegistry;
import com.oneidentity.safeguard.safeguardjava.event.IDisconnectHandler;
import com.oneidentity.safeguard.safeguardjava.event.ISafeguardEventHandler;
import com.oneidentity.safeguard.safeguardjava.event.ISafeguardEventListener;
import com.oneidentity.safeguard.safeguardjava.event.SafeguardEventListener;
import com.oneidentity.safeguard.safeguardjava.exceptions.ArgumentException;
import com.oneidentity.safeguard.safeguardjava.exceptions.ObjectDisposedException;
import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardForJavaException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PersistentSafeguardEventListenerBase
implements ISafeguardEventListener {
    private boolean disposed;
    private SafeguardEventListener eventListener;
    private final EventHandlerRegistry eventHandlerRegistry = new EventHandlerRegistry();
    private Thread reconnectThread = null;
    boolean isCancellationRequested = false;

    protected PersistentSafeguardEventListenerBase() {
    }

    @Override
    public void registerEventHandler(String eventName, ISafeguardEventHandler handler) throws ObjectDisposedException {
        if (this.disposed) {
            throw new ObjectDisposedException("PersistentSafeguardEventListener");
        }
        this.eventHandlerRegistry.registerEventHandler(eventName, handler);
    }

    protected abstract SafeguardEventListener reconnectEventListener() throws ObjectDisposedException, SafeguardForJavaException, ArgumentException;

    private void persistentReconnectAndStart() {
        if (this.reconnectThread != null) {
            return;
        }
        this.isCancellationRequested = false;
        this.reconnectThread = new Thread(){

            @Override
            public void run() {
                while (!PersistentSafeguardEventListenerBase.this.isCancellationRequested) {
                    try {
                        if (PersistentSafeguardEventListenerBase.this.eventListener != null) {
                            PersistentSafeguardEventListenerBase.this.eventListener.dispose();
                        }
                        Logger.getLogger(PersistentSafeguardEventListenerBase.class.getName()).log(Level.FINEST, "Attempting to connect and start internal event listener.");
                        PersistentSafeguardEventListenerBase.this.eventListener = PersistentSafeguardEventListenerBase.this.reconnectEventListener();
                        PersistentSafeguardEventListenerBase.this.eventListener.setEventHandlerRegistry(PersistentSafeguardEventListenerBase.this.eventHandlerRegistry);
                        PersistentSafeguardEventListenerBase.this.eventListener.start();
                        PersistentSafeguardEventListenerBase.this.eventListener.setDisconnectHandler(new PersistentReconnectAndStartHandler());
                        break;
                    }
                    catch (ArgumentException | ObjectDisposedException | SafeguardForJavaException ex) {
                        Logger.getLogger(PersistentSafeguardEventListenerBase.class.getName()).log(Level.WARNING, "Internal event listener connection error (see debug for more information), sleeping for 5 seconds...");
                        Logger.getLogger(PersistentSafeguardEventListenerBase.class.getName()).log(Level.FINEST, "Internal event listener connection error.");
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        };
        try {
            this.reconnectThread.start();
            this.reconnectThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.isCancellationRequested) {
            this.reconnectThread = null;
        }
    }

    @Override
    public void start() throws ObjectDisposedException {
        if (this.disposed) {
            throw new ObjectDisposedException("PersistentSafeguardEventListener");
        }
        Logger.getLogger(PersistentSafeguardEventListenerBase.class.getName()).log(Level.INFO, "Internal event listener requested to start.");
        this.persistentReconnectAndStart();
    }

    @Override
    public void stop() throws ObjectDisposedException, SafeguardForJavaException {
        if (this.disposed) {
            throw new ObjectDisposedException("PersistentSafeguardEventListener");
        }
        Logger.getLogger(PersistentSafeguardEventListenerBase.class.getName()).log(Level.INFO, "Internal event listener requested to stop.");
        this.isCancellationRequested = true;
        if (this.eventListener != null) {
            this.eventListener.stop();
        }
    }

    @Override
    public boolean isStarted() {
        return this.eventListener == null ? false : this.eventListener.isStarted();
    }

    @Override
    public void dispose() {
        if (this.eventListener != null) {
            this.eventListener.dispose();
        }
        this.disposed = true;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.eventListener != null) {
                this.eventListener.dispose();
            }
        }
        finally {
            this.disposed = true;
        }
    }

    class PersistentReconnectAndStartHandler
    implements IDisconnectHandler {
        PersistentReconnectAndStartHandler() {
        }

        @Override
        public void func() {
            PersistentSafeguardEventListenerBase.this.persistentReconnectAndStart();
        }
    }
}

