/*
 * Decompiled with CFR 0.152.
 */
package com.oneidentity.safeguard.safeguardjava.event;

import com.google.gson.JsonElement;
import com.oneidentity.safeguard.safeguardjava.data.CertificateContext;
import com.oneidentity.safeguard.safeguardjava.event.DefaultDisconnectHandler;
import com.oneidentity.safeguard.safeguardjava.event.EventHandlerRegistry;
import com.oneidentity.safeguard.safeguardjava.event.IDisconnectHandler;
import com.oneidentity.safeguard.safeguardjava.event.ISafeguardEventHandler;
import com.oneidentity.safeguard.safeguardjava.event.ISafeguardEventListener;
import com.oneidentity.safeguard.safeguardjava.exceptions.ArgumentException;
import com.oneidentity.safeguard.safeguardjava.exceptions.ObjectDisposedException;
import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardEventListenerDisconnectedException;
import com.oneidentity.safeguard.safeguardjava.exceptions.SafeguardForJavaException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import microsoft.aspnet.signalr.client.ErrorCallback;
import microsoft.aspnet.signalr.client.MessageReceivedHandler;
import microsoft.aspnet.signalr.client.SignalRFuture;
import microsoft.aspnet.signalr.client.hubs.HubConnection;
import microsoft.aspnet.signalr.client.hubs.HubProxy;

public class SafeguardEventListener
implements ISafeguardEventListener {
    private boolean disposed;
    private final String eventUrl;
    private final boolean ignoreSsl;
    private char[] accessToken;
    private char[] apiKey;
    private List<char[]> apiKeys;
    private CertificateContext clientCertificate;
    private EventHandlerRegistry eventHandlerRegistry;
    private IDisconnectHandler disconnectHandler;
    private HubConnection signalrConnection = null;
    private SignalRFuture<Void> signalrFuture = null;
    public HubProxy signalrHubProxy = null;
    private static final String NOTIFICATION_HUB = "notificationHub";

    private SafeguardEventListener(String eventUrl, boolean ignoreSsl) {
        this.eventUrl = eventUrl;
        this.ignoreSsl = ignoreSsl;
        this.eventHandlerRegistry = new EventHandlerRegistry();
        this.accessToken = null;
        this.apiKey = null;
        this.apiKeys = null;
        this.clientCertificate = null;
        this.disconnectHandler = new DefaultDisconnectHandler();
    }

    public SafeguardEventListener(String eventUrl, char[] accessToken, boolean ignoreSsl) throws ArgumentException {
        this(eventUrl, ignoreSsl);
        if (accessToken == null) {
            throw new ArgumentException("The accessToken parameter can not be null");
        }
        this.accessToken = (char[])accessToken.clone();
    }

    public SafeguardEventListener(String eventUrl, String clientCertificatePath, char[] certificatePassword, String certificateAlias, char[] apiKey, boolean ignoreSsl) throws ArgumentException {
        this(eventUrl, ignoreSsl);
        if (apiKey == null) {
            throw new ArgumentException("The apiKey parameter can not be null");
        }
        this.apiKey = (char[])apiKey.clone();
        this.clientCertificate = new CertificateContext(certificateAlias, clientCertificatePath, certificatePassword);
    }

    public SafeguardEventListener(String eventUrl, CertificateContext clientCertificate, char[] apiKey, boolean ignoreSsl) throws ArgumentException {
        this(eventUrl, ignoreSsl);
        if (apiKey == null) {
            throw new ArgumentException("The apiKey parameter can not be null");
        }
        this.clientCertificate = clientCertificate.cloneObject();
        this.apiKey = (char[])apiKey.clone();
    }

    public SafeguardEventListener(String eventUrl, String clientCertificatePath, char[] certificatePassword, String certificateAlias, List<char[]> apiKeys, boolean ignoreSsl) throws ArgumentException {
        this(eventUrl, ignoreSsl);
        if (apiKeys == null) {
            throw new ArgumentException("The apiKey parameter can not be null");
        }
        this.clientCertificate = new CertificateContext(certificateAlias, clientCertificatePath, certificatePassword);
        this.apiKeys = new ArrayList<char[]>();
        for (char[] key : apiKeys) {
            apiKeys.add((char[])key.clone());
        }
        if (apiKeys.isEmpty()) {
            throw new ArgumentException("The apiKeys parameter must include at least one item");
        }
    }

    public SafeguardEventListener(String eventUrl, CertificateContext clientCertificate, List<char[]> apiKeys, boolean ignoreSsl) throws ArgumentException {
        this(eventUrl, ignoreSsl);
        if (apiKeys == null) {
            throw new ArgumentException("The apiKeys parameter can not be null");
        }
        this.clientCertificate = clientCertificate.cloneObject();
        this.apiKeys = new ArrayList<char[]>();
        for (char[] key : apiKeys) {
            apiKeys.add((char[])key.clone());
        }
        if (apiKeys.isEmpty()) {
            throw new ArgumentException("The apiKeys parameter must include at least one item");
        }
    }

    public void setDisconnectHandler(IDisconnectHandler handler) {
        this.disconnectHandler = handler;
    }

    public void setEventHandlerRegistry(EventHandlerRegistry registry) {
        this.eventHandlerRegistry = registry;
    }

    private void handleEvent(JsonElement eventObject) {
        this.eventHandlerRegistry.handleEvent(eventObject);
    }

    private void handleDisconnect() throws SafeguardEventListenerDisconnectedException {
        if (!this.isStarted()) {
            return;
        }
        Logger.getLogger(EventHandlerRegistry.class.getName()).log(Level.WARNING, "SignalR disconnect detected, calling handler...");
        this.disconnectHandler.func();
    }

    private void cleanupConnection() {
        this.signalrConnection = null;
        this.signalrHubProxy = null;
        this.signalrFuture = null;
    }

    @Override
    public boolean isStarted() {
        return this.signalrFuture == null ? false : this.signalrFuture.isDone();
    }

    @Override
    public void registerEventHandler(String eventName, ISafeguardEventHandler handler) throws ObjectDisposedException {
        if (this.disposed) {
            throw new ObjectDisposedException("SafeguardEventListener");
        }
        this.eventHandlerRegistry.registerEventHandler(eventName, handler);
    }

    @Override
    public void start() throws ObjectDisposedException, SafeguardForJavaException, SafeguardEventListenerDisconnectedException {
        if (this.disposed) {
            throw new ObjectDisposedException("SafeguardEventListener");
        }
        this.cleanupConnection();
        this.signalrConnection = new HubConnection(this.eventUrl);
        if (this.accessToken != null) {
            this.signalrConnection.getHeaders().put("Authorization", String.format("Bearer %s", new String(this.accessToken)));
        } else {
            String authKey = "";
            if (this.apiKey != null) {
                authKey = new String(this.apiKey);
            } else if (this.apiKeys != null) {
                for (char[] key : this.apiKeys) {
                    authKey = authKey + new String(key) + " ";
                }
                authKey = authKey.trim();
            }
            if (authKey.isEmpty()) {
                throw new SafeguardForJavaException("No API keys found in the authorization header");
            }
            this.signalrConnection.getHeaders().put("Authorization", String.format("A2A %s", authKey));
            this.signalrConnection.setClientCertificate(this.clientCertificate.getCertificatePath(), this.clientCertificate.getCertificatePassword(), this.clientCertificate.getCertificateAlias());
        }
        this.signalrHubProxy = this.signalrConnection.createHubProxy(NOTIFICATION_HUB);
        try {
            this.signalrFuture = this.signalrConnection.start(this.ignoreSsl);
            this.signalrConnection.received(new MessageReceivedHandler(){

                @Override
                public void onMessageReceived(JsonElement json) {
                    SafeguardEventListener.this.handleEvent(json);
                }
            });
            this.signalrConnection.closed(new Runnable(){

                @Override
                public void run() {
                    try {
                        SafeguardEventListener.this.handleDisconnect();
                    }
                    catch (SafeguardEventListenerDisconnectedException ex) {
                        Logger.getLogger(SafeguardEventListener.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
            this.signalrConnection.error(new ErrorCallback(){

                @Override
                public void onError(Throwable error) {
                    Logger.getLogger(EventHandlerRegistry.class.getName()).log(Level.WARNING, "SignalR error detected...", error.getMessage());
                }
            });
        }
        catch (Exception ex) {
            throw new SafeguardForJavaException("Failure starting SignalR", ex);
        }
    }

    @Override
    public void stop() throws ObjectDisposedException, SafeguardForJavaException {
        if (this.disposed) {
            throw new ObjectDisposedException("SafeguardEventListener");
        }
        try {
            if (this.signalrConnection != null) {
                this.signalrConnection.stop();
            }
            this.cleanupConnection();
        }
        catch (Exception ex) {
            throw new SafeguardForJavaException("Failure stopping SignalR.", ex);
        }
    }

    @Override
    public void dispose() {
        this.cleanupConnection();
        if (this.clientCertificate != null) {
            this.clientCertificate.dispose();
        }
        if (this.apiKey != null) {
            Arrays.fill(this.apiKey, '0');
        }
        if (this.apiKeys != null) {
            for (char[] key : this.apiKeys) {
                Arrays.fill(key, '0');
            }
        }
        if (this.accessToken != null) {
            Arrays.fill(this.accessToken, '0');
        }
        this.disposed = true;
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanupConnection();
            if (this.clientCertificate != null) {
                this.clientCertificate.dispose();
            }
            if (this.apiKey != null) {
                Arrays.fill(this.apiKey, '0');
            }
            if (this.apiKeys != null) {
                for (char[] key : this.apiKeys) {
                    Arrays.fill(key, '0');
                }
            }
            if (this.accessToken != null) {
                Arrays.fill(this.accessToken, '0');
            }
            this.disposed = true;
        }
        finally {
            this.disposed = true;
            super.finalize();
        }
    }
}

