/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import microsoft.aspnet.signalr.client.Action;
import microsoft.aspnet.signalr.client.ConnectionBase;
import microsoft.aspnet.signalr.client.ConnectionState;
import microsoft.aspnet.signalr.client.Credentials;
import microsoft.aspnet.signalr.client.DateSerializer;
import microsoft.aspnet.signalr.client.ErrorCallback;
import microsoft.aspnet.signalr.client.HeartbeatMonitor;
import microsoft.aspnet.signalr.client.InvalidProtocolVersionException;
import microsoft.aspnet.signalr.client.InvalidStateException;
import microsoft.aspnet.signalr.client.KeepAliveData;
import microsoft.aspnet.signalr.client.LogLevel;
import microsoft.aspnet.signalr.client.Logger;
import microsoft.aspnet.signalr.client.MessageReceivedHandler;
import microsoft.aspnet.signalr.client.MessageResult;
import microsoft.aspnet.signalr.client.NullLogger;
import microsoft.aspnet.signalr.client.SignalRFuture;
import microsoft.aspnet.signalr.client.StateChangedCallback;
import microsoft.aspnet.signalr.client.UpdateableCancellableFuture;
import microsoft.aspnet.signalr.client.Version;
import microsoft.aspnet.signalr.client.http.Request;
import microsoft.aspnet.signalr.client.transport.AutomaticTransport;
import microsoft.aspnet.signalr.client.transport.ClientTransport;
import microsoft.aspnet.signalr.client.transport.ConnectionType;
import microsoft.aspnet.signalr.client.transport.DataResultCallback;
import microsoft.aspnet.signalr.client.transport.NegotiationResponse;
import microsoft.aspnet.signalr.client.transport.TransportHelper;

public class Connection
implements ConnectionBase {
    public static final Version PROTOCOL_VERSION = new Version("1.3");
    private Logger mLogger;
    private String mUrl;
    private String mConnectionToken;
    private String mConnectionId;
    private String mMessageId;
    private String mGroupsToken;
    private Credentials mCredentials;
    private String mQueryString;
    private Map<String, String> mHeaders = new HashMap<String, String>();
    private UpdateableCancellableFuture<Void> mConnectionFuture;
    private boolean mAborting = false;
    private SignalRFuture<Void> mAbortFuture = new SignalRFuture();
    private Runnable mOnReconnecting;
    private Runnable mOnReconnected;
    private Runnable mOnConnected;
    private MessageReceivedHandler mOnReceived;
    private ErrorCallback mOnError;
    private Runnable mOnConnectionSlow;
    private Runnable mOnClosed;
    private StateChangedCallback mOnStateChanged;
    private ClientTransport mTransport;
    private HeartbeatMonitor mHeartbeatMonitor;
    private KeepAliveData mKeepAliveData;
    protected ConnectionState mState;
    protected JsonParser mJsonParser;
    protected Gson mGson;
    private final Object mStateLock = new Object();
    private final Object mStartLock = new Object();
    private String mClientCertificatePath = null;
    private char[] mClientCertificatePassword = null;
    private String mClientCertificateAlias = null;

    public Connection(String url) {
        this(url, (String)null);
    }

    public Connection(String url, String queryString) {
        this(url, queryString, new NullLogger());
    }

    public Connection(String url, Logger logger) {
        this(url, null, logger);
    }

    public Connection(String url, String queryString, Logger logger) {
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("Logger cannot be null");
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        this.log("Initialize the connection", LogLevel.Information);
        this.log("Connection data: " + url + " - " + queryString == null ? "" : queryString, LogLevel.Verbose);
        this.mUrl = url;
        this.mQueryString = queryString;
        this.mLogger = logger;
        this.mJsonParser = new JsonParser();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter((Type)((Object)Date.class), new DateSerializer());
        this.mGson = gsonBuilder.create();
        this.mState = ConnectionState.Disconnected;
    }

    @Override
    public Logger getLogger() {
        return this.mLogger;
    }

    @Override
    public ConnectionState getState() {
        return this.mState;
    }

    @Override
    public String getUrl() {
        return this.mUrl;
    }

    @Override
    public String getConnectionToken() {
        return this.mConnectionToken;
    }

    @Override
    public String getConnectionId() {
        return this.mConnectionId;
    }

    @Override
    public String getQueryString() {
        return this.mQueryString;
    }

    @Override
    public String getMessageId() {
        return this.mMessageId;
    }

    @Override
    public void setMessageId(String messageId) {
        this.mMessageId = messageId;
    }

    @Override
    public String getGroupsToken() {
        return this.mGroupsToken;
    }

    @Override
    public void setGroupsToken(String groupsToken) {
        this.mGroupsToken = groupsToken;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    @Override
    public void reconnecting(Runnable handler) {
        this.mOnReconnecting = handler;
    }

    @Override
    public void reconnected(Runnable handler) {
        this.mOnReconnected = handler;
    }

    @Override
    public void connected(Runnable handler) {
        this.mOnConnected = handler;
    }

    @Override
    public void error(ErrorCallback handler) {
        this.mOnError = handler;
    }

    @Override
    public void received(MessageReceivedHandler handler) {
        this.mOnReceived = handler;
    }

    @Override
    public void connectionSlow(Runnable handler) {
        this.mOnConnectionSlow = handler;
    }

    @Override
    public void closed(Runnable handler) {
        this.mOnClosed = handler;
    }

    @Override
    public void stateChanged(StateChangedCallback handler) {
        this.mOnStateChanged = handler;
    }

    @Override
    public void setClientCertificate(String clientCertificatePath, char[] clientCertificatePassword, String clientCertificateAlias) {
        this.mClientCertificatePath = clientCertificatePath;
        this.mClientCertificatePassword = clientCertificatePassword;
        this.mClientCertificateAlias = clientCertificateAlias;
    }

    public SignalRFuture<Void> start(boolean ignoreSsl) {
        return this.start(new AutomaticTransport(this.mLogger, this.mClientCertificatePath, this.mClientCertificatePassword, this.mClientCertificateAlias, ignoreSsl));
    }

    public SignalRFuture<Void> send(Object object) {
        String data = null;
        if (object != null) {
            data = object instanceof JsonElement ? object.toString() : this.mGson.toJson(object);
        }
        return this.send(data);
    }

    @Override
    public SignalRFuture<Void> send(String data) {
        this.log("Sending: " + data, LogLevel.Information);
        if (this.mState == ConnectionState.Disconnected || this.mState == ConnectionState.Connecting) {
            this.onError(new InvalidStateException(this.mState), false);
            return new SignalRFuture<Void>();
        }
        final Connection that = this;
        this.log("Invoking send on transport", LogLevel.Verbose);
        SignalRFuture<Void> future = this.mTransport.send(this, data, new DataResultCallback(){

            @Override
            public void onData(String data) {
                that.processReceivedData(data);
            }
        });
        this.handleFutureError(future, false);
        return future;
    }

    private void handleFutureError(SignalRFuture<?> future, final boolean mustCleanCurrentConnection) {
        final Connection that = this;
        future.onError(new ErrorCallback(){

            @Override
            public void onError(Throwable error) {
                that.onError(error, mustCleanCurrentConnection);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignalRFuture<Void> start(ClientTransport transport) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.log("Entered startLock in start", LogLevel.Verbose);
            if (!this.changeState(ConnectionState.Disconnected, ConnectionState.Connecting)) {
                this.log("Couldn't change state from disconnected to connecting.", LogLevel.Verbose);
                return this.mConnectionFuture;
            }
            this.log("Start the connection, using " + transport.getName() + " transport", LogLevel.Information);
            this.mTransport = transport;
            this.mConnectionFuture = new UpdateableCancellableFuture(null);
            this.handleFutureError(this.mConnectionFuture, true);
            this.log("Start negotiation", LogLevel.Verbose);
            SignalRFuture<NegotiationResponse> negotiationFuture = transport.negotiate(this);
            try {
                negotiationFuture.done(new Action<NegotiationResponse>(){

                    @Override
                    public void run(NegotiationResponse negotiationResponse) throws Exception {
                        Connection.this.log("Negotiation completed", LogLevel.Information);
                        if (!Connection.verifyProtocolVersion(negotiationResponse.getProtocolVersion())) {
                            InvalidProtocolVersionException err = new InvalidProtocolVersionException(negotiationResponse.getProtocolVersion());
                            Connection.this.onError(err, true);
                            Connection.this.mConnectionFuture.triggerError(err);
                            return;
                        }
                        Connection.this.mConnectionId = negotiationResponse.getConnectionId();
                        Connection.this.mConnectionToken = negotiationResponse.getConnectionToken();
                        Connection.this.log("ConnectionId: " + Connection.this.mConnectionId, LogLevel.Verbose);
                        Connection.this.log("ConnectionToken: " + Connection.this.mConnectionToken, LogLevel.Verbose);
                        KeepAliveData keepAliveData = null;
                        if (negotiationResponse.getKeepAliveTimeout() > 0.0) {
                            Connection.this.log("Keep alive timeout: " + negotiationResponse.getKeepAliveTimeout(), LogLevel.Verbose);
                            keepAliveData = new KeepAliveData((long)(negotiationResponse.getKeepAliveTimeout() * 1000.0));
                        }
                        Connection.this.startTransport(keepAliveData, false);
                    }
                });
                negotiationFuture.onError(new ErrorCallback(){

                    @Override
                    public void onError(Throwable error) {
                        Connection.this.mConnectionFuture.triggerError(error);
                    }
                });
            }
            catch (Exception e) {
                this.onError(e, true);
            }
            this.handleFutureError(negotiationFuture, true);
            this.mConnectionFuture.setFuture(negotiationFuture);
            return this.mConnectionFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changeState(ConnectionState oldState, ConnectionState newState) {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == oldState) {
                this.mState = newState;
                if (this.mOnStateChanged != null) {
                    try {
                        this.mOnStateChanged.stateChanged(oldState, newState);
                    }
                    catch (Throwable e) {
                        this.onError(e, false);
                    }
                }
                return true;
            }
            return false;
        }
    }

    @Override
    public Credentials getCredentials() {
        return this.mCredentials;
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.mCredentials = credentials;
    }

    @Override
    public void prepareRequest(Request request) {
        if (this.mCredentials != null) {
            this.log("Preparing request with credentials data", LogLevel.Information);
            this.mCredentials.prepareRequest(request);
        }
        if (this.mHeaders != null) {
            this.mHeaders.entrySet().stream().forEach(entry -> request.addHeader((String)entry.getKey(), (String)entry.getValue()));
        }
    }

    @Override
    public String getConnectionData() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.mStartLock;
        synchronized (object) {
            this.log("Entered startLock in stop", LogLevel.Verbose);
            if (this.mAborting) {
                this.log("Abort already started.", LogLevel.Verbose);
                return;
            }
            if (this.mState == ConnectionState.Disconnected) {
                this.log("Connection already in disconnected state. Exiting abort", LogLevel.Verbose);
                return;
            }
            this.log("Stopping the connection", LogLevel.Information);
            this.mAborting = true;
            this.log("Starting abort operation", LogLevel.Verbose);
            this.mAbortFuture = this.mTransport.abort(this);
            final Connection that = this;
            this.mAbortFuture.onError(new ErrorCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onError(Throwable error) {
                    Object object = Connection.this.mStartLock;
                    synchronized (object) {
                        that.onError(error, false);
                        Connection.this.disconnect();
                        Connection.this.mAborting = false;
                    }
                }
            });
            this.mAbortFuture.onCancelled(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = Connection.this.mStartLock;
                    synchronized (object) {
                        Connection.this.log("Abort cancelled", LogLevel.Verbose);
                        Connection.this.mAborting = false;
                    }
                }
            });
            this.mAbortFuture.done(new Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(Void obj) throws Exception {
                    Object object = Connection.this.mStartLock;
                    synchronized (object) {
                        Connection.this.log("Abort completed", LogLevel.Information);
                        Connection.this.disconnect();
                        Connection.this.mAborting = false;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.log("Entered stateLock in disconnect", LogLevel.Verbose);
            if (this.mState == ConnectionState.Disconnected) {
                return;
            }
            this.log("Disconnecting", LogLevel.Information);
            ConnectionState oldState = this.mState;
            this.mState = ConnectionState.Disconnected;
            if (this.mOnStateChanged != null) {
                try {
                    this.mOnStateChanged.stateChanged(oldState, ConnectionState.Disconnected);
                }
                catch (Throwable e) {
                    this.onError(e, false);
                }
            }
            if (this.mHeartbeatMonitor != null) {
                this.log("Stopping Heartbeat monitor", LogLevel.Verbose);
                this.mHeartbeatMonitor.stop();
            }
            this.mHeartbeatMonitor = null;
            if (this.mConnectionFuture != null) {
                this.log("Stopping the connection", LogLevel.Verbose);
                this.mConnectionFuture.cancel();
                this.mConnectionFuture = new UpdateableCancellableFuture(null);
            }
            if (this.mAbortFuture != null) {
                this.log("Cancelling abort", LogLevel.Verbose);
                this.mAbortFuture.cancel();
            }
            this.mConnectionId = null;
            this.mConnectionToken = null;
            this.mCredentials = null;
            this.mGroupsToken = null;
            this.mHeaders.clear();
            this.mMessageId = null;
            this.mTransport = null;
            this.mClientCertificateAlias = null;
            if (this.mClientCertificatePassword != null) {
                Arrays.fill(this.mClientCertificatePassword, '0');
            }
            this.mClientCertificatePath = null;
            this.onClosed();
        }
    }

    @Override
    public Gson getGson() {
        return this.mGson;
    }

    @Override
    public void setGson(Gson gson) {
        this.mGson = gson;
    }

    @Override
    public JsonParser getJsonParser() {
        return this.mJsonParser;
    }

    protected void onReconnecting() {
        if (this.mOnReconnecting != null) {
            this.mOnReconnecting.run();
        }
    }

    protected void onReconnected() {
        if (this.mOnReconnected != null) {
            this.mOnReconnected.run();
        }
    }

    protected void onConnected() {
        if (this.mOnConnected != null) {
            this.mOnConnected.run();
        }
    }

    private static boolean verifyProtocolVersion(String versionString) {
        try {
            if (versionString == null || versionString.equals("")) {
                return false;
            }
            Version version = new Version(versionString);
            return version.equals(PROTOCOL_VERSION);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTransport(KeepAliveData keepAliveData, boolean isReconnecting) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.log("Entered startLock in startTransport", LogLevel.Verbose);
            if (this.mTransport == null) {
                this.log("Transport is null. Exiting startTransport", LogLevel.Verbose);
                return;
            }
            this.log("Starting the transport", LogLevel.Information);
            if (isReconnecting) {
                if (this.mHeartbeatMonitor != null) {
                    this.log("Stopping heartbeat monitor", LogLevel.Verbose);
                    this.mHeartbeatMonitor.stop();
                }
                this.changeState(ConnectionState.Connected, ConnectionState.Reconnecting);
                this.onReconnecting();
            }
            this.mHeartbeatMonitor = new HeartbeatMonitor();
            this.mHeartbeatMonitor.setOnWarning(new Runnable(){

                @Override
                public void run() {
                    Connection.this.log("Slow connection detected", LogLevel.Information);
                    if (Connection.this.mOnConnectionSlow != null) {
                        Connection.this.mOnConnectionSlow.run();
                    }
                }
            });
            this.mHeartbeatMonitor.setOnTimeout(new Runnable(){

                @Override
                public void run() {
                    Connection.this.log("Timeout", LogLevel.Information);
                    Connection.this.reconnect();
                }
            });
            final Connection that = this;
            ConnectionType connectionType = isReconnecting ? ConnectionType.Reconnection : ConnectionType.InitialConnection;
            this.log("Starting transport for " + connectionType.toString(), LogLevel.Verbose);
            SignalRFuture<Void> future = this.mTransport.start(this, connectionType, new DataResultCallback(){

                @Override
                public void onData(String data) {
                    Connection.this.log("Received data: ", LogLevel.Verbose);
                    Connection.this.processReceivedData(data);
                }
            });
            this.handleFutureError(future, true);
            this.mConnectionFuture.setFuture(future);
            future.onError(new ErrorCallback(){

                @Override
                public void onError(Throwable error) {
                    Connection.this.mConnectionFuture.triggerError(error);
                }
            });
            this.mKeepAliveData = keepAliveData;
            try {
                future.done(new Action<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run(Void obj) throws Exception {
                        Object object = Connection.this.mStartLock;
                        synchronized (object) {
                            Connection.this.log("Entered startLock after transport was started", LogLevel.Verbose);
                            Connection.this.log("Current state: " + (Object)((Object)Connection.this.mState), LogLevel.Verbose);
                            if (Connection.this.changeState(ConnectionState.Reconnecting, ConnectionState.Connected)) {
                                Connection.this.log("Starting Heartbeat monitor", LogLevel.Verbose);
                                Connection.this.mHeartbeatMonitor.start(Connection.this.mKeepAliveData, that);
                                Connection.this.log("Reconnected", LogLevel.Information);
                                Connection.this.onReconnected();
                            } else if (Connection.this.changeState(ConnectionState.Connecting, ConnectionState.Connected)) {
                                Connection.this.log("Starting Heartbeat monitor", LogLevel.Verbose);
                                Connection.this.mHeartbeatMonitor.start(Connection.this.mKeepAliveData, that);
                                Connection.this.log("Connected", LogLevel.Information);
                                Connection.this.onConnected();
                                Connection.this.mConnectionFuture.setResult(null);
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                this.onError(e, false);
            }
        }
    }

    private void processReceivedData(String data) {
        MessageResult result;
        if (this.mHeartbeatMonitor != null) {
            this.mHeartbeatMonitor.beat();
        }
        if ((result = TransportHelper.processReceivedData(data, this)).disconnect()) {
            this.disconnect();
            return;
        }
        if (result.reconnect()) {
            this.reconnect();
        }
    }

    protected JsonElement processMessage(JsonElement message) throws Exception {
        return message;
    }

    @Override
    public void onError(Throwable error, boolean mustCleanCurrentConnection) {
        this.log(error);
        if (mustCleanCurrentConnection) {
            if (this.mState == ConnectionState.Connected) {
                this.log("Triggering reconnect", LogLevel.Verbose);
                this.reconnect();
            } else {
                this.log("Triggering disconnect", LogLevel.Verbose);
                this.disconnect();
                if (this.mOnError != null) {
                    this.mOnError.onError(error);
                }
            }
        } else if (this.mOnError != null) {
            this.mOnError.onError(error);
        }
    }

    protected void onClosed() {
        if (this.mOnClosed != null) {
            this.mOnClosed.run();
        }
    }

    private void reconnect() {
        if (this.mState == ConnectionState.Connected) {
            this.log("Stopping Heartbeat monitor", LogLevel.Verbose);
            this.mHeartbeatMonitor.stop();
            this.log("Restarting the transport", LogLevel.Information);
            this.startTransport(this.mHeartbeatMonitor.getKeepAliveData(), true);
        }
    }

    protected void log(String message, LogLevel level) {
        if (message != null & this.mLogger != null) {
            this.mLogger.log(this.getSourceNameForLog() + " - " + message, level);
        }
    }

    protected void log(Throwable error) {
        this.mLogger.log(this.getSourceNameForLog() + " - Error: " + error.toString(), LogLevel.Critical);
    }

    protected String getSourceNameForLog() {
        return "Connection";
    }

    @Override
    public void onReceived(JsonElement message) {
        if (this.mOnReceived != null && this.getState() == ConnectionState.Connected) {
            this.log("Invoking messageReceived with: " + message, LogLevel.Verbose);
            try {
                this.mOnReceived.onMessageReceived(message);
            }
            catch (Throwable error) {
                this.onError(error, false);
            }
        }
    }
}

