/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client;

import java.util.Locale;
import microsoft.aspnet.signalr.client.Logger;
import microsoft.aspnet.signalr.client.PlatformComponent;
import microsoft.aspnet.signalr.client.http.HttpConnection;
import microsoft.aspnet.signalr.client.http.java.JavaHttpConnection;

public class Platform {
    static boolean mPlatformVerified = false;
    static boolean mIsAndroid = false;
    static PlatformComponent mPlatformComponent = null;

    public static void loadPlatformComponent(PlatformComponent platformComponent) {
        mPlatformComponent = platformComponent;
    }

    public static HttpConnection createHttpConnection(Logger logger) {
        if (mPlatformComponent != null) {
            return mPlatformComponent.createHttpConnection(logger);
        }
        return Platform.createDefaultHttpConnection(logger);
    }

    public static HttpConnection createDefaultHttpConnection(Logger logger) {
        return new JavaHttpConnection(logger, null, null, null, false);
    }

    public static HttpConnection createHttpConnection(Logger logger, String clientCertificatePath, char[] clientCertificatePassword, String clientCertificateAlias, boolean ignoreSsl) {
        if (mPlatformComponent != null) {
            return mPlatformComponent.createHttpConnection(logger, clientCertificatePath, clientCertificatePassword, clientCertificateAlias, ignoreSsl);
        }
        return Platform.createDefaultHttpConnection(logger, clientCertificatePath, clientCertificatePassword, clientCertificateAlias, ignoreSsl);
    }

    public static HttpConnection createDefaultHttpConnection(Logger logger, String clientCertificatePath, char[] clientCertificatePassword, String clientCertificateAlias, boolean ignoreSsl) {
        return new JavaHttpConnection(logger, clientCertificatePath, clientCertificatePassword, clientCertificateAlias, ignoreSsl);
    }

    public static String getUserAgent() {
        String osName = mPlatformComponent != null ? mPlatformComponent.getOSName() : System.getProperty("os.name").toLowerCase(Locale.getDefault());
        String userAgent = String.format("SignalR (lang=Java; os=%s; version=2.0)", osName);
        return userAgent;
    }
}

