/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client.http;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import microsoft.aspnet.signalr.client.LogLevel;
import microsoft.aspnet.signalr.client.Logger;
import microsoft.aspnet.signalr.client.SimpleEntry;

public class Request {
    private String mVerb;
    private String mContent;
    private HashMap<String, String> mHeaders = new HashMap();
    private String mUrl;

    public Request(String httpVerb) {
        this.mVerb = httpVerb;
    }

    public void setContent(String content) {
        this.mContent = content;
    }

    public String getContent() {
        return this.mContent;
    }

    public void setFormContent(String name, String value) {
        ArrayList<Map.Entry<String, String>> formValues = new ArrayList<Map.Entry<String, String>>();
        formValues.add(new SimpleEntry<String, String>(name, value));
        this.setFormContent(formValues);
    }

    public void setFormContent(List<Map.Entry<String, String>> formValues) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : formValues) {
            try {
                sb.append(String.format("%s=%s&", URLEncoder.encode(entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue(), "UTF-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        this.mContent = sb.toString();
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.mHeaders);
        return copy;
    }

    public void setHeaders(Map<String, String> headers) {
        this.mHeaders = new HashMap();
        if (headers != null) {
            this.mHeaders.putAll(headers);
        }
    }

    public void addHeader(String name, String value) {
        this.mHeaders.put(name, value);
    }

    public void removeHeader(String name) {
        this.mHeaders.remove(name);
    }

    public void setVerb(String httpVerb) {
        this.mVerb = httpVerb;
    }

    public String getVerb() {
        return this.mVerb;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void log(Logger logger) {
        if (logger != null) {
            logger.log("URL: " + this.getUrl(), LogLevel.Verbose);
            logger.log("VERB: " + this.getVerb(), LogLevel.Verbose);
            for (String key : this.mHeaders.keySet()) {
                logger.log("Header " + key + ": " + this.mHeaders.get(key), LogLevel.Verbose);
            }
            logger.log("CONTENT: " + this.getContent(), LogLevel.Verbose);
        }
    }
}

