/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client.http.java;

import microsoft.aspnet.signalr.client.LogLevel;
import microsoft.aspnet.signalr.client.Logger;
import microsoft.aspnet.signalr.client.Platform;
import microsoft.aspnet.signalr.client.http.HttpConnection;
import microsoft.aspnet.signalr.client.http.HttpConnectionFuture;
import microsoft.aspnet.signalr.client.http.Request;
import microsoft.aspnet.signalr.client.http.java.NetworkRunnable;
import microsoft.aspnet.signalr.client.http.java.NetworkThread;

public class JavaHttpConnection
implements HttpConnection {
    private static final String USER_AGENT_HEADER = "User-Agent";
    private final Logger mLogger;
    private String mClientCertificatePath = null;
    private char[] mClientCertificatePassword = null;
    private String mClientCertificateAlias = null;
    private boolean mIgnoreSsl = false;

    public JavaHttpConnection(Logger logger, String clientCertificatePath, char[] clientCertificatePassword, String clientCertificateAlias, boolean ignoreSsl) {
        this.mLogger = logger;
        this.mIgnoreSsl = ignoreSsl;
        this.mClientCertificatePath = clientCertificatePath;
        this.mClientCertificatePassword = clientCertificatePassword == null ? null : (char[])clientCertificatePassword.clone();
        this.mClientCertificateAlias = clientCertificateAlias;
    }

    @Override
    public HttpConnectionFuture execute(Request request, HttpConnectionFuture.ResponseCallback callback) {
        request.addHeader(USER_AGENT_HEADER, Platform.getUserAgent());
        this.mLogger.log("Create new thread for HTTP Connection", LogLevel.Verbose);
        HttpConnectionFuture future = new HttpConnectionFuture();
        final NetworkRunnable target = new NetworkRunnable(this.mLogger, request, future, callback, this.mClientCertificatePath, this.mClientCertificatePassword, this.mClientCertificateAlias, this.mIgnoreSsl);
        final NetworkThread networkThread = new NetworkThread((Runnable)target){

            @Override
            void releaseAndStop() {
                try {
                    target.closeStreamAndConnection();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        future.onCancelled(new Runnable(){

            @Override
            public void run() {
                networkThread.releaseAndStop();
            }
        });
        networkThread.start();
        return future;
    }
}

