/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client.http.java;

import com.oneidentity.safeguard.safeguardjava.restclient.RestClient;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import microsoft.aspnet.signalr.client.LogLevel;
import microsoft.aspnet.signalr.client.Logger;
import microsoft.aspnet.signalr.client.http.HttpConnectionFuture;
import microsoft.aspnet.signalr.client.http.Request;
import microsoft.aspnet.signalr.client.http.StreamResponse;

class NetworkRunnable
implements Runnable {
    HttpURLConnection mConnection = null;
    InputStream mResponseStream = null;
    Logger mLogger;
    Request mRequest;
    HttpConnectionFuture mFuture;
    HttpConnectionFuture.ResponseCallback mCallback;
    String mClientCertificatePath = null;
    char[] mClientCertificatePassword = null;
    String mClientCertificateAlias = null;
    boolean mIgnoreSsl = false;
    Object mCloseLock = new Object();
    static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }};

    private NetworkRunnable(Logger logger, Request request, HttpConnectionFuture future, HttpConnectionFuture.ResponseCallback callback, boolean ignoreSsl) {
        this.mLogger = logger;
        this.mRequest = request;
        this.mFuture = future;
        this.mCallback = callback;
        this.mIgnoreSsl = ignoreSsl;
    }

    public NetworkRunnable(Logger logger, Request request, HttpConnectionFuture future, HttpConnectionFuture.ResponseCallback callback, String clientCertificatePath, char[] clientCertificatePassword, String clientCertificateAlias, boolean ignoreSsl) {
        this(logger, request, future, callback, ignoreSsl);
        this.mClientCertificatePath = clientCertificatePath;
        this.mClientCertificatePassword = clientCertificatePassword == null ? null : (char[])clientCertificatePassword.clone();
        this.mClientCertificateAlias = clientCertificateAlias;
    }

    @Override
    public void run() {
        try {
            int responseCode = -1;
            if (!this.mFuture.isCancelled()) {
                if (this.mRequest == null) {
                    this.mFuture.triggerError(new IllegalArgumentException("request"));
                    return;
                }
                this.mLogger.log("Execute the HTTP Request", LogLevel.Verbose);
                this.mRequest.log(this.mLogger);
                this.mConnection = this.mRequest.getUrl().startsWith("https") ? NetworkRunnable.createHttpsURLConnection(this.mRequest, this.mClientCertificatePath, this.mClientCertificatePassword, this.mClientCertificateAlias, this.mIgnoreSsl) : NetworkRunnable.createHttpURLConnection(this.mRequest);
                this.mLogger.log("Request executed", LogLevel.Verbose);
                responseCode = this.mConnection.getResponseCode();
                this.mResponseStream = responseCode < 400 ? this.mConnection.getInputStream() : this.mConnection.getErrorStream();
            }
            if (this.mResponseStream != null && !this.mFuture.isCancelled()) {
                this.mCallback.onResponse(new StreamResponse(this.mResponseStream, responseCode, this.mConnection.getHeaderFields()));
                this.mFuture.setResult(null);
            }
        }
        catch (Throwable e) {
            if (!this.mFuture.isCancelled()) {
                if (this.mConnection != null) {
                    this.mConnection.disconnect();
                }
                this.mLogger.log("Error executing request: " + e.getMessage(), LogLevel.Critical);
                this.mFuture.triggerError(e);
            }
        }
        finally {
            this.closeStreamAndConnection();
        }
    }

    void closeStreamAndConnection() {
        try {
            if (this.mConnection != null) {
                this.mConnection.disconnect();
            }
            if (this.mResponseStream != null) {
                this.mResponseStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static HttpURLConnection createHttpURLConnection(Request request) throws IOException {
        URL url = new URL(request.getUrl());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(15000);
        connection.setRequestMethod(request.getVerb());
        Map<String, String> headers = request.getHeaders();
        for (String key : headers.keySet()) {
            connection.setRequestProperty(key, headers.get(key));
        }
        if (request.getContent() != null) {
            connection.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
            String requestContent = request.getContent();
            out.write(requestContent);
            out.close();
        }
        return connection;
    }

    static HttpsURLConnection createHttpsURLConnection(Request request, String certificatePath, char[] certificatePassword, String certificateAlias, boolean ignoreSsl) throws IOException {
        URL url = new URL(request.getUrl());
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setConnectTimeout(15000);
        connection.setRequestMethod(request.getVerb());
        SSLContext sslContext = NetworkRunnable.getSSLContext(certificatePath, certificatePassword, certificateAlias, ignoreSsl);
        connection.setSSLSocketFactory(sslContext.getSocketFactory());
        Map<String, String> headers = request.getHeaders();
        for (String key : headers.keySet()) {
            connection.setRequestProperty(key, headers.get(key));
        }
        if (request.getContent() != null) {
            connection.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
            String requestContent = request.getContent();
            out.write(requestContent);
            out.close();
        }
        return connection;
    }

    static SSLContext getSSLContext(String keyStorePath, char[] keyStorePassword, String alias, boolean ignoreSsl) {
        TrustManager[] customTrustManager = null;
        KeyManager[] customKeyManager = null;
        if (ignoreSsl) {
            customTrustManager = trustAllCerts;
        }
        if (keyStorePath != null && keyStorePassword != null) {
            KeyStore clientKs = null;
            ArrayList<String> aliases = null;
            try {
                FileInputStream in = new FileInputStream(keyStorePath);
                clientKs = KeyStore.getInstance("JKS");
                clientKs.load(in, keyStorePassword);
                aliases = Collections.list(clientKs.aliases());
                ((InputStream)in).close();
                if (alias == null && aliases != null && aliases.size() > 0) {
                    alias = (String)aliases.get(0);
                }
            }
            catch (FileNotFoundException ex) {
                java.util.logging.Logger.getLogger(RestClient.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                java.util.logging.Logger.getLogger(RestClient.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (alias != null) {
                try {
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                    keyManagerFactory.init(clientKs, keyStorePassword);
                    customKeyManager = new KeyManager[]{new ExtendedX509KeyManager((X509KeyManager)keyManagerFactory.getKeyManagers()[0], alias)};
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
                    ex.printStackTrace();
                }
            }
        }
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(customKeyManager, customTrustManager, new SecureRandom());
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return ctx;
    }

    static class ExtendedX509KeyManager
    extends X509ExtendedKeyManager {
        X509KeyManager defaultKeyManager;
        String alias;

        public ExtendedX509KeyManager(X509KeyManager inKeyManager, String alias) {
            this.defaultKeyManager = inKeyManager;
            this.alias = alias;
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            return this.alias;
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] prncpls, Socket socket) {
            return this.alias;
        }

        @Override
        public String[] getClientAliases(String string, Principal[] prncpls) {
            return this.defaultKeyManager.getClientAliases(string, prncpls);
        }

        @Override
        public String[] getServerAliases(String string, Principal[] prncpls) {
            return this.defaultKeyManager.getServerAliases(string, prncpls);
        }

        @Override
        public String chooseServerAlias(String string, Principal[] prncpls, Socket socket) {
            return this.defaultKeyManager.chooseServerAlias(string, prncpls, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String string) {
            return this.defaultKeyManager.getCertificateChain(string);
        }

        @Override
        public PrivateKey getPrivateKey(String string) {
            return this.defaultKeyManager.getPrivateKey(string);
        }
    }
}

