/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client.hubs;

import com.google.gson.JsonElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import microsoft.aspnet.signalr.client.Action;
import microsoft.aspnet.signalr.client.ErrorCallback;
import microsoft.aspnet.signalr.client.LogLevel;
import microsoft.aspnet.signalr.client.Logger;
import microsoft.aspnet.signalr.client.SignalRFuture;
import microsoft.aspnet.signalr.client.hubs.HubConnection;
import microsoft.aspnet.signalr.client.hubs.HubException;
import microsoft.aspnet.signalr.client.hubs.HubInvocation;
import microsoft.aspnet.signalr.client.hubs.HubResult;
import microsoft.aspnet.signalr.client.hubs.Subscription;
import microsoft.aspnet.signalr.client.hubs.SubscriptionHandler;
import microsoft.aspnet.signalr.client.hubs.SubscriptionHandler1;
import microsoft.aspnet.signalr.client.hubs.SubscriptionHandler2;
import microsoft.aspnet.signalr.client.hubs.SubscriptionHandler3;
import microsoft.aspnet.signalr.client.hubs.SubscriptionHandler4;
import microsoft.aspnet.signalr.client.hubs.SubscriptionHandler5;

public class HubProxy {
    private String mHubName;
    private HubConnection mConnection;
    private Map<String, Subscription> mSubscriptions = Collections.synchronizedMap(new HashMap());
    private Map<String, JsonElement> mState = Collections.synchronizedMap(new HashMap());
    private Logger mLogger;
    private static final List<String> EXCLUDED_METHODS = Arrays.asList("equals", "getClass", "hashCode", "notify", "notifyAll", "toString", "wait");
    private static final String SUBSCRIPTION_HANDLER_METHOD = "run";

    protected HubProxy(HubConnection connection, String hubName, Logger logger) {
        this.mConnection = connection;
        this.mHubName = hubName;
        this.mLogger = logger;
    }

    public void setState(String key, JsonElement state) {
        this.mState.put(key, state);
    }

    public JsonElement getState(String key) {
        return this.mState.get(key);
    }

    public <E> E getValue(String key, Class<E> clazz) {
        return this.mConnection.getGson().fromJson(this.getState(key), clazz);
    }

    public Subscription subscribe(String eventName) {
        Subscription subscription;
        this.log("Subscribe to event " + eventName, LogLevel.Information);
        if (eventName == null) {
            throw new IllegalArgumentException("eventName cannot be null");
        }
        if (this.mSubscriptions.containsKey(eventName = eventName.toLowerCase(Locale.getDefault()))) {
            this.log("Adding event to existing subscription: " + eventName, LogLevel.Information);
            subscription = this.mSubscriptions.get(eventName);
        } else {
            this.log("Creating new subscription for: " + eventName, LogLevel.Information);
            subscription = new Subscription();
            this.mSubscriptions.put(eventName, subscription);
        }
        return subscription;
    }

    public void subscribe(final Object handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        Method[] methods = handler.getClass().getMethods();
        for (int j = 0; j < methods.length; ++j) {
            final Method method = methods[j];
            if (EXCLUDED_METHODS.contains(method.getName())) continue;
            Subscription subscription = this.subscribe(method.getName());
            subscription.addReceivedHandler(new Action<JsonElement[]>(){

                @Override
                public void run(JsonElement[] eventParameters) throws Exception {
                    HubProxy.this.log("Handling dynamic subscription: " + method.getName(), LogLevel.Verbose);
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length != eventParameters.length) {
                        throw new RuntimeException("The handler has " + parameterTypes.length + " parameters, but there are " + eventParameters.length + " values.");
                    }
                    Object[] parameters = new Object[parameterTypes.length];
                    for (int i = 0; i < eventParameters.length; ++i) {
                        parameters[i] = HubProxy.this.mConnection.getGson().fromJson(eventParameters[i], parameterTypes[i]);
                    }
                    method.setAccessible(true);
                    HubProxy.this.log("Invoking method for dynamic subscription: " + method.getName(), LogLevel.Verbose);
                    method.invoke(handler, parameters);
                }
            });
        }
    }

    public void removeSubscription(String eventName) {
        if (eventName != null) {
            this.mSubscriptions.remove(eventName.toLowerCase(Locale.getDefault()));
        }
    }

    public SignalRFuture<Void> invoke(String method, Object ... args) {
        return this.invoke(null, method, args);
    }

    public <E> SignalRFuture<E> invoke(final Class<E> resultClass, final String method, Object ... args) {
        if (method == null) {
            throw new IllegalArgumentException("method cannot be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("args cannot be null");
        }
        this.log("Invoking method on hub: " + method, LogLevel.Information);
        JsonElement[] jsonArguments = new JsonElement[args.length];
        for (int i = 0; i < args.length; ++i) {
            jsonArguments[i] = this.mConnection.getGson().toJsonTree(args[i]);
        }
        final SignalRFuture resultFuture = new SignalRFuture();
        final String callbackId = this.mConnection.registerCallback(new Action<HubResult>(){

            @Override
            public void run(HubResult result) {
                HubProxy.this.log("Executing invocation callback for: " + method, LogLevel.Information);
                if (result != null) {
                    if (result.getError() != null) {
                        if (result.isHubException()) {
                            resultFuture.triggerError(new HubException(result.getError(), result.getErrorData()));
                        } else {
                            resultFuture.triggerError(new Exception(result.getError()));
                        }
                    } else {
                        boolean errorHappened = false;
                        Object resultObject = null;
                        try {
                            if (result.getState() != null) {
                                for (String key : result.getState().keySet()) {
                                    HubProxy.this.setState(key, result.getState().get(key));
                                }
                            }
                            if (result.getResult() != null && resultClass != null) {
                                HubProxy.this.log("Found result invoking method on hub: " + result.getResult(), LogLevel.Information);
                                resultObject = HubProxy.this.mConnection.getGson().fromJson(result.getResult(), resultClass);
                            }
                        }
                        catch (Exception e) {
                            errorHappened = true;
                            resultFuture.triggerError(e);
                        }
                        if (!errorHappened) {
                            try {
                                resultFuture.setResult(resultObject);
                            }
                            catch (Exception e) {
                                resultFuture.triggerError(e);
                            }
                        }
                    }
                }
            }
        });
        HubInvocation hubData = new HubInvocation();
        hubData.setHub(this.mHubName);
        hubData.setMethod(method);
        hubData.setArgs(jsonArguments);
        hubData.setCallbackId(callbackId);
        if (this.mState.size() != 0) {
            hubData.setState(this.mState);
        }
        final SignalRFuture<Void> sendFuture = this.mConnection.send(hubData);
        resultFuture.onCancelled(new Runnable(){

            @Override
            public void run() {
                HubProxy.this.mConnection.removeCallback(callbackId);
            }
        });
        resultFuture.onError(new ErrorCallback(){

            @Override
            public void onError(Throwable error) {
                sendFuture.triggerError(error);
            }
        });
        return resultFuture;
    }

    public <E> SignalRFuture<E> invoke(Class<E> resultClass, final Type resultType, final String method, Object ... args) {
        if (method == null) {
            throw new IllegalArgumentException("method cannot be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("args cannot be null");
        }
        this.log("Invoking method on hub: " + method, LogLevel.Information);
        JsonElement[] jsonArguments = new JsonElement[args.length];
        for (int i = 0; i < args.length; ++i) {
            jsonArguments[i] = this.mConnection.getGson().toJsonTree(args[i]);
        }
        final SignalRFuture resultFuture = new SignalRFuture();
        final String callbackId = this.mConnection.registerCallback(new Action<HubResult>(){

            @Override
            public void run(HubResult result) {
                HubProxy.this.log("Executing invocation callback for: " + method, LogLevel.Information);
                if (result != null) {
                    if (result.getError() != null) {
                        if (result.isHubException()) {
                            resultFuture.triggerError(new HubException(result.getError(), result.getErrorData()));
                        } else {
                            resultFuture.triggerError(new Exception(result.getError()));
                        }
                    } else {
                        boolean errorHappened = false;
                        Object resultObject = null;
                        try {
                            if (result.getState() != null) {
                                for (String key : result.getState().keySet()) {
                                    HubProxy.this.setState(key, result.getState().get(key));
                                }
                            }
                            if (result.getResult() != null && resultType != null) {
                                HubProxy.this.log("Found result invoking method on hub: " + result.getResult(), LogLevel.Information);
                                resultObject = HubProxy.this.mConnection.getGson().fromJson(result.getResult(), resultType);
                            }
                        }
                        catch (Exception e) {
                            errorHappened = true;
                            resultFuture.triggerError(e);
                        }
                        if (!errorHappened) {
                            try {
                                resultFuture.setResult(resultObject);
                            }
                            catch (Exception e) {
                                resultFuture.triggerError(e);
                            }
                        }
                    }
                }
            }
        });
        HubInvocation hubData = new HubInvocation();
        hubData.setHub(this.mHubName);
        hubData.setMethod(method);
        hubData.setArgs(jsonArguments);
        hubData.setCallbackId(callbackId);
        if (this.mState.size() != 0) {
            hubData.setState(this.mState);
        }
        final SignalRFuture<Void> sendFuture = this.mConnection.send(hubData);
        resultFuture.onCancelled(new Runnable(){

            @Override
            public void run() {
                HubProxy.this.mConnection.removeCallback(callbackId);
            }
        });
        resultFuture.onError(new ErrorCallback(){

            @Override
            public void onError(Throwable error) {
                sendFuture.triggerError(error);
            }
        });
        return resultFuture;
    }

    void invokeEvent(String eventName, JsonElement[] args) throws Exception {
        if (eventName == null) {
            throw new IllegalArgumentException("eventName cannot be null");
        }
        if (this.mSubscriptions.containsKey(eventName = eventName.toLowerCase(Locale.getDefault()))) {
            Subscription subscription = this.mSubscriptions.get(eventName);
            subscription.onReceived(args);
        }
    }

    private <E1, E2, E3, E4, E5> void on(String eventName, final SubscriptionHandler5<E1, E2, E3, E4, E5> handler, final Class<?> ... parameterTypes) {
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        Subscription subscription = this.subscribe(eventName);
        subscription.addReceivedHandler(new Action<JsonElement[]>(){

            @Override
            public void run(JsonElement[] eventParameters) throws Exception {
                Method method = null;
                for (Method m : handler.getClass().getMethods()) {
                    if (!m.getName().equals(HubProxy.SUBSCRIPTION_HANDLER_METHOD)) continue;
                    method = m;
                    break;
                }
                if (parameterTypes.length != eventParameters.length) {
                    throw new RuntimeException("The handler has " + parameterTypes.length + " parameters, but there are " + eventParameters.length + " values.");
                }
                Object[] parameters = new Object[5];
                for (int i = 0; i < eventParameters.length; ++i) {
                    parameters[i] = HubProxy.this.mConnection.getGson().fromJson(eventParameters[i], parameterTypes[i]);
                }
                method.setAccessible(true);
                method.invoke((Object)handler, parameters);
            }
        });
    }

    public <E1, E2, E3, E4, E5> void on(String eventName, final SubscriptionHandler5<E1, E2, E3, E4, E5> handler, Class<E1> parameter1, Class<E2> parameter2, Class<E3> parameter3, Class<E4> parameter4, Class<E5> parameter5) {
        this.on(eventName, (SubscriptionHandler5<E1, E2, E3, E4, E5>)new SubscriptionHandler5<E1, E2, E3, E4, E5>(){

            @Override
            public void run(E1 p1, E2 p2, E3 p3, E4 p4, E5 p5) {
                handler.run(p1, p2, p3, p4, p5);
            }
        }, parameter1, parameter2, parameter3, parameter4, parameter5);
    }

    public <E1, E2, E3, E4> void on(String eventName, final SubscriptionHandler4<E1, E2, E3, E4> handler, Class<E1> parameter1, Class<E2> parameter2, Class<E3> parameter3, Class<E4> parameter4) {
        this.on(eventName, new SubscriptionHandler5<E1, E2, E3, E4, Void>(){

            @Override
            public void run(E1 p1, E2 p2, E3 p3, E4 p4, Void p5) {
                handler.run(p1, p2, p3, p4);
            }
        }, parameter1, parameter2, parameter3, parameter4);
    }

    public <E1, E2, E3> void on(String eventName, final SubscriptionHandler3<E1, E2, E3> handler, Class<E1> parameter1, Class<E2> parameter2, Class<E3> parameter3) {
        this.on(eventName, new SubscriptionHandler5<E1, E2, E3, Void, Void>(){

            @Override
            public void run(E1 p1, E2 p2, E3 p3, Void p4, Void p5) {
                handler.run(p1, p2, p3);
            }
        }, parameter1, parameter2, parameter3);
    }

    public <E1, E2> void on(String eventName, final SubscriptionHandler2<E1, E2> handler, Class<E1> parameter1, Class<E2> parameter2) {
        this.on(eventName, new SubscriptionHandler5<E1, E2, Void, Void, Void>(){

            @Override
            public void run(E1 p1, E2 p2, Void p3, Void p4, Void p5) {
                handler.run(p1, p2);
            }
        }, parameter1, parameter2);
    }

    public <E1> void on(String eventName, final SubscriptionHandler1<E1> handler, Class<E1> parameter1) {
        this.on(eventName, new SubscriptionHandler5<E1, Void, Void, Void, Void>(){

            @Override
            public void run(E1 p1, Void p2, Void p3, Void p4, Void p5) {
                handler.run(p1);
            }
        }, parameter1);
    }

    public <E1> void on(String eventName, final SubscriptionHandler handler) {
        this.on(eventName, new SubscriptionHandler5<Void, Void, Void, Void, Void>(){

            @Override
            public void run(Void p1, Void p2, Void p3, Void p4, Void p5) {
                handler.run();
            }
        }, new Class[0]);
    }

    protected void log(String message, LogLevel level) {
        if (message != null & this.mLogger != null) {
            this.mLogger.log("HubProxy " + this.mHubName + " - " + message, level);
        }
    }
}

