/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client.transport;

import microsoft.aspnet.signalr.client.ConnectionBase;
import microsoft.aspnet.signalr.client.LogLevel;
import microsoft.aspnet.signalr.client.Logger;
import microsoft.aspnet.signalr.client.SignalRFuture;
import microsoft.aspnet.signalr.client.http.HttpConnection;
import microsoft.aspnet.signalr.client.http.HttpConnectionFuture;
import microsoft.aspnet.signalr.client.http.Request;
import microsoft.aspnet.signalr.client.http.Response;
import microsoft.aspnet.signalr.client.transport.ConnectionType;
import microsoft.aspnet.signalr.client.transport.DataResultCallback;
import microsoft.aspnet.signalr.client.transport.HttpClientTransport;
import microsoft.aspnet.signalr.client.transport.TransportHelper;

public class ServerSentEventsTransport
extends HttpClientTransport {
    private static final int SSE_DATA_PREFIX_LENGTH = 6;
    private static final String DATA_INITIALIZED = "data: initialized";
    private static final String END_OF_SSE_MESSAGE = "\n\n";
    private SignalRFuture<Void> mConnectionFuture;

    public ServerSentEventsTransport(Logger logger, String clientCertificatePath, char[] clientCertificatePassword, String clientCertificateAlias, boolean ignoreSsl) {
        super(logger, clientCertificatePath, clientCertificatePassword, clientCertificateAlias, ignoreSsl);
    }

    public ServerSentEventsTransport(Logger logger, HttpConnection httpConnection) {
        super(logger, httpConnection);
    }

    @Override
    public String getName() {
        return "serverSentEvents";
    }

    @Override
    public boolean supportKeepAlive() {
        return true;
    }

    @Override
    public SignalRFuture<Void> start(ConnectionBase connection, ConnectionType connectionType, final DataResultCallback callback) {
        this.log("Start the communication with the server", LogLevel.Information);
        String url = connection.getUrl() + (connectionType == ConnectionType.InitialConnection ? "connect" : "reconnect") + TransportHelper.getReceiveQueryString(this, connection);
        Request get = new Request("GET");
        get.setUrl(url);
        get.setHeaders(connection.getHeaders());
        get.addHeader("Accept", "text/event-stream");
        connection.prepareRequest(get);
        this.log("Execute the request", LogLevel.Verbose);
        this.mConnectionFuture = this.mHttpConnection.execute(get, new HttpConnectionFuture.ResponseCallback(){

            @Override
            public void onResponse(Response response) {
                block5: {
                    try {
                        ServerSentEventsTransport.this.log("Response received", LogLevel.Verbose);
                        ServerSentEventsTransport.this.throwOnInvalidStatusCode(response);
                        ServerSentEventsTransport.this.mConnectionFuture.setResult(null);
                        StringBuilder buffer = new StringBuilder();
                        String line = null;
                        ServerSentEventsTransport.this.log("Read the response content by line", LogLevel.Verbose);
                        while ((line = response.readLine()) != null) {
                            buffer.append(line);
                            buffer.append("\n");
                            String currentData = buffer.toString();
                            if (!currentData.endsWith(ServerSentEventsTransport.END_OF_SSE_MESSAGE)) continue;
                            currentData = currentData.trim();
                            ServerSentEventsTransport.this.log("Found new data: " + currentData, LogLevel.Verbose);
                            if (currentData.equals(ServerSentEventsTransport.DATA_INITIALIZED)) {
                                ServerSentEventsTransport.this.log("Initialization message found", LogLevel.Verbose);
                            } else {
                                String content = currentData.substring(6).trim();
                                ServerSentEventsTransport.this.log("Trigger onData: " + content, LogLevel.Verbose);
                                callback.onData(content);
                            }
                            buffer = new StringBuilder();
                        }
                    }
                    catch (Throwable e) {
                        if (ServerSentEventsTransport.this.mConnectionFuture.isCancelled()) break block5;
                        ServerSentEventsTransport.this.mConnectionFuture.triggerError(e);
                    }
                }
            }
        });
        return this.mConnectionFuture;
    }
}

