/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client.transport;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import microsoft.aspnet.signalr.client.Connection;
import microsoft.aspnet.signalr.client.ConnectionBase;
import microsoft.aspnet.signalr.client.LogLevel;
import microsoft.aspnet.signalr.client.Logger;
import microsoft.aspnet.signalr.client.MessageResult;
import microsoft.aspnet.signalr.client.transport.ClientTransport;

public class TransportHelper {
    public static MessageResult processReceivedData(String data, ConnectionBase connection) {
        Logger logger = connection.getLogger();
        MessageResult result = new MessageResult();
        if (data == null) {
            return result;
        }
        if ("".equals(data = data.trim())) {
            return result;
        }
        JsonObject json = null;
        try {
            json = connection.getJsonParser().parse(data).getAsJsonObject();
        }
        catch (Exception e) {
            connection.onError(e, false);
            return result;
        }
        if (json.entrySet().size() == 0) {
            return result;
        }
        if (json.get("I") != null) {
            logger.log("Invoking message received with: " + json.toString(), LogLevel.Verbose);
            connection.onReceived(json);
        } else {
            JsonElement messages;
            if (json.get("D") != null && json.get("D").getAsInt() == 1) {
                logger.log("Disconnect message received", LogLevel.Verbose);
                result.setDisconnect(true);
                return result;
            }
            if (json.get("T") != null && json.get("T").getAsInt() == 1) {
                logger.log("Reconnect message received", LogLevel.Verbose);
                result.setReconnect(true);
            }
            if (json.get("G") != null) {
                String groupsToken = json.get("G").getAsString();
                logger.log("Group token received: " + groupsToken, LogLevel.Verbose);
                connection.setGroupsToken(groupsToken);
            }
            if ((messages = json.get("M")) != null && messages.isJsonArray()) {
                if (json.get("C") != null) {
                    String messageId = json.get("C").getAsString();
                    logger.log("MessageId received: " + messageId, LogLevel.Verbose);
                    connection.setMessageId(messageId);
                }
                JsonArray messagesArray = messages.getAsJsonArray();
                int size = messagesArray.size();
                for (int i = 0; i < size; ++i) {
                    JsonElement message = messagesArray.get(i);
                    Object processedMessage = null;
                    logger.log("Invoking OnReceived with: " + processedMessage, LogLevel.Verbose);
                    connection.onReceived(message);
                }
            }
            if (json.get("S") != null && json.get("S").getAsInt() == 1) {
                logger.log("Initialization message received", LogLevel.Information);
                result.setInitialize(true);
            }
        }
        return result;
    }

    public static String getReceiveQueryString(ClientTransport transport, ConnectionBase connection) {
        String connectionData;
        StringBuilder qsBuilder = new StringBuilder();
        qsBuilder.append("?transport=" + transport.getName()).append("&connectionToken=" + TransportHelper.urlEncode(connection.getConnectionToken()));
        qsBuilder.append("&connectionId=" + TransportHelper.urlEncode(connection.getConnectionId()));
        if (connection.getMessageId() != null) {
            qsBuilder.append("&messageId=" + TransportHelper.urlEncode(connection.getMessageId()));
        }
        if (connection.getGroupsToken() != null) {
            qsBuilder.append("&groupsToken=" + TransportHelper.urlEncode(connection.getGroupsToken()));
        }
        if ((connectionData = connection.getConnectionData()) != null) {
            qsBuilder.append("&connectionData=" + TransportHelper.urlEncode(connectionData));
        }
        qsBuilder.append("&tid=" + Math.floor(Math.random() * 11.0));
        String customQuery = connection.getQueryString();
        if (customQuery != null) {
            qsBuilder.append("&").append(customQuery);
        }
        return qsBuilder.toString();
    }

    public static String getNegotiateQueryString(ConnectionBase connection) {
        StringBuilder qsBuilder = new StringBuilder();
        qsBuilder.append("?clientProtocol=" + TransportHelper.urlEncode(Connection.PROTOCOL_VERSION.toString()));
        if (connection.getConnectionData() != null) {
            qsBuilder.append("&").append("connectionData=" + TransportHelper.urlEncode(connection.getConnectionData()));
        }
        if (connection.getQueryString() != null) {
            qsBuilder.append("&").append(connection.getQueryString());
        }
        return qsBuilder.toString();
    }

    public static String getSendQueryString(ClientTransport transport, ConnectionBase connection) {
        StringBuilder qsBuilder = new StringBuilder();
        qsBuilder.append("?transport=" + TransportHelper.urlEncode(transport.getName()));
        qsBuilder.append("&connectionToken=" + TransportHelper.urlEncode(connection.getConnectionToken()));
        qsBuilder.append("&connectionId=" + TransportHelper.urlEncode(connection.getConnectionId()));
        if (connection.getConnectionData() != null) {
            qsBuilder.append("&connectionData=" + TransportHelper.urlEncode(connection.getConnectionData()));
        }
        if (connection.getQueryString() != null) {
            qsBuilder.append("&").append(connection.getQueryString());
        }
        return qsBuilder.toString();
    }

    public static String urlEncode(String s) {
        if (s == null) {
            return "";
        }
        String encoded = null;
        try {
            encoded = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encoded;
    }
}

