/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client.transport;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.oneidentity.safeguard.safeguardjava.restclient.RestClient;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import microsoft.aspnet.signalr.client.ConnectionBase;
import microsoft.aspnet.signalr.client.Logger;
import microsoft.aspnet.signalr.client.SignalRFuture;
import microsoft.aspnet.signalr.client.UpdateableCancellableFuture;
import microsoft.aspnet.signalr.client.http.HttpConnection;
import microsoft.aspnet.signalr.client.transport.ConnectionType;
import microsoft.aspnet.signalr.client.transport.DataResultCallback;
import microsoft.aspnet.signalr.client.transport.HttpClientTransport;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class WebsocketTransport
extends HttpClientTransport {
    private String mPrefix;
    private static final Gson gson = new Gson();
    WebSocketClient mWebSocketClient;
    private UpdateableCancellableFuture<Void> mConnectionFuture;
    final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }};
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String WS = "ws";
    private static final String WSS = "wss";

    public WebsocketTransport(Logger logger, String clientCertificatePath, char[] clientCertificatePassword, String clientCertificateAlias, boolean ignoreSsl) {
        super(logger, clientCertificatePath, clientCertificatePassword, clientCertificateAlias, ignoreSsl);
    }

    public WebsocketTransport(Logger logger, HttpConnection httpConnection) {
        super(logger, httpConnection);
    }

    @Override
    public String getName() {
        return "webSockets";
    }

    @Override
    public boolean supportKeepAlive() {
        return true;
    }

    @Override
    public SignalRFuture<Void> start(ConnectionBase connection, ConnectionType connectionType, final DataResultCallback callback) {
        URI uri;
        String connectionString = connectionType == ConnectionType.InitialConnection ? "connect" : "reconnect";
        String transport = this.getName();
        String connectionToken = connection.getConnectionToken();
        String messageId = connection.getMessageId() != null ? connection.getMessageId() : "";
        String groupsToken = connection.getGroupsToken() != null ? connection.getGroupsToken() : "";
        String connectionData = connection.getConnectionData() != null ? connection.getConnectionData() : "";
        String url = null;
        try {
            url = this.formatUrl(connection.getUrl()) + connectionString + '?' + "&transport=" + URLEncoder.encode(transport, "UTF-8") + "&connectionToken=" + URLEncoder.encode(connectionToken, "UTF-8") + "&connectionData=" + URLEncoder.encode(connectionData, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.mConnectionFuture = new UpdateableCancellableFuture(null);
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            this.mConnectionFuture.triggerError(e);
            return this.mConnectionFuture;
        }
        this.mWebSocketClient = new WebSocketClient(uri, connection.getHeaders()){

            @Override
            public void onOpen(ServerHandshake serverHandshake) {
                WebsocketTransport.this.mConnectionFuture.setResult(null);
            }

            @Override
            public void onMessage(String s) {
                callback.onData(s);
            }

            @Override
            public void onClose(int i, String s, boolean b) {
                WebsocketTransport.this.mWebSocketClient.close();
            }

            @Override
            public void onError(Exception e) {
                WebsocketTransport.this.mWebSocketClient.close();
            }
        };
        SSLContext sslContext = this.getSSLContext(null);
        this.mWebSocketClient.setSocketFactory(sslContext.getSocketFactory());
        this.mWebSocketClient.connect();
        connection.closed(new Runnable(){

            @Override
            public void run() {
                WebsocketTransport.this.mWebSocketClient.close();
            }
        });
        return this.mConnectionFuture;
    }

    @Override
    public SignalRFuture<Void> send(ConnectionBase connection, String data, DataResultCallback callback) {
        this.mWebSocketClient.send(data);
        return new UpdateableCancellableFuture<Void>(null);
    }

    private boolean isJSONValid(String test) {
        try {
            gson.fromJson(test, Object.class);
            return true;
        }
        catch (JsonSyntaxException ex) {
            return false;
        }
    }

    private String formatUrl(String url) {
        if (url.startsWith(HTTPS)) {
            url = WSS + url.substring(HTTPS.length());
        } else if (url.startsWith(HTTP)) {
            url = WS + url.substring(HTTP.length());
        }
        return url;
    }

    private SSLContext getSSLContext(String alias) {
        TrustManager[] customTrustManager = null;
        KeyManager[] customKeyManager = null;
        if (this.mIgnoreSsl) {
            customTrustManager = this.trustAllCerts;
        }
        if (this.mClientCertificatePath != null && this.mClientCertificatePassword != null) {
            KeyStore clientKs = null;
            ArrayList<String> aliases = null;
            try {
                FileInputStream in = new FileInputStream(this.mClientCertificatePath);
                clientKs = KeyStore.getInstance("JKS");
                clientKs.load(in, this.mClientCertificatePassword);
                aliases = Collections.list(clientKs.aliases());
                ((InputStream)in).close();
                if (alias == null && aliases != null && aliases.size() > 0) {
                    alias = (String)aliases.get(0);
                }
            }
            catch (FileNotFoundException ex) {
                java.util.logging.Logger.getLogger(RestClient.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                java.util.logging.Logger.getLogger(RestClient.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (alias != null) {
                try {
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                    keyManagerFactory.init(clientKs, this.mClientCertificatePassword);
                    customKeyManager = new KeyManager[]{new ExtendedX509KeyManager((X509KeyManager)keyManagerFactory.getKeyManagers()[0], alias)};
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
                    ex.printStackTrace();
                }
            }
        }
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(customKeyManager, customTrustManager, new SecureRandom());
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return ctx;
    }

    class ExtendedX509KeyManager
    extends X509ExtendedKeyManager {
        X509KeyManager defaultKeyManager;
        String alias;

        public ExtendedX509KeyManager(X509KeyManager inKeyManager, String alias) {
            this.defaultKeyManager = inKeyManager;
            this.alias = alias;
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            return this.alias;
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] prncpls, Socket socket) {
            return this.alias;
        }

        @Override
        public String[] getClientAliases(String string, Principal[] prncpls) {
            return this.defaultKeyManager.getClientAliases(string, prncpls);
        }

        @Override
        public String[] getServerAliases(String string, Principal[] prncpls) {
            return this.defaultKeyManager.getServerAliases(string, prncpls);
        }

        @Override
        public String chooseServerAlias(String string, Principal[] prncpls, Socket socket) {
            return this.defaultKeyManager.chooseServerAlias(string, prncpls, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String string) {
            return this.defaultKeyManager.getCertificateChain(string);
        }

        @Override
        public PrivateKey getPrivateKey(String string) {
            return this.defaultKeyManager.getPrivateKey(string);
        }
    }
}

