/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.inAppMessages.internal;

import com.onesignal.core.internal.time.ITime;
import com.onesignal.debug.internal.logging.Logging;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bB\r\u0012\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0000J\u0006\u0010%\u001a\u00020\u001bJ\u0006\u0010&\u001a\u00020\nJ\b\u0010'\u001a\u00020(H\u0016R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u001e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010\u0012\u00a8\u0006*"}, d2={"Lcom/onesignal/inAppMessages/internal/InAppMessageRedisplayStats;", "", "displayQuantity", "", "lastDisplayTime", "", "time", "Lcom/onesignal/core/internal/time/ITime;", "(IJLcom/onesignal/core/internal/time/ITime;)V", "json", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;Lcom/onesignal/core/internal/time/ITime;)V", "_time", "(Lcom/onesignal/core/internal/time/ITime;)V", "displayDelay", "getDisplayDelay", "()J", "setDisplayDelay", "(J)V", "displayLimit", "getDisplayLimit", "()I", "setDisplayLimit", "(I)V", "getDisplayQuantity", "setDisplayQuantity", "isDelayTimeSatisfied", "", "()Z", "<set-?>", "isRedisplayEnabled", "getLastDisplayTime", "setLastDisplayTime", "incrementDisplayQuantity", "", "setDisplayStats", "displayStats", "shouldDisplayAgain", "toJSONObject", "toString", "", "Companion", "com.onesignal.inAppMessages"})
public final class InAppMessageRedisplayStats {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ITime _time;
    private long lastDisplayTime;
    private int displayQuantity;
    private int displayLimit;
    private long displayDelay;
    private boolean isRedisplayEnabled;
    @NotNull
    private static final String DISPLAY_LIMIT = "limit";
    @NotNull
    private static final String DISPLAY_DELAY = "delay";

    public InAppMessageRedisplayStats(@NotNull ITime _time) {
        Intrinsics.checkNotNullParameter((Object)_time, (String)"_time");
        this._time = _time;
        this.lastDisplayTime = -1L;
        this.displayLimit = 1;
    }

    public final long getLastDisplayTime() {
        return this.lastDisplayTime;
    }

    public final void setLastDisplayTime(long l) {
        this.lastDisplayTime = l;
    }

    public final int getDisplayQuantity() {
        return this.displayQuantity;
    }

    public final void setDisplayQuantity(int n) {
        this.displayQuantity = n;
    }

    public final int getDisplayLimit() {
        return this.displayLimit;
    }

    public final void setDisplayLimit(int n) {
        this.displayLimit = n;
    }

    public final long getDisplayDelay() {
        return this.displayDelay;
    }

    public final void setDisplayDelay(long l) {
        this.displayDelay = l;
    }

    public final boolean isRedisplayEnabled() {
        return this.isRedisplayEnabled;
    }

    public InAppMessageRedisplayStats(int displayQuantity, long lastDisplayTime, @NotNull ITime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this(time);
        this.displayQuantity = displayQuantity;
        this.lastDisplayTime = lastDisplayTime;
    }

    public InAppMessageRedisplayStats(@NotNull JSONObject json2, @NotNull ITime time) {
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this(time);
        this.isRedisplayEnabled = true;
        Object displayLimit = json2.get(DISPLAY_LIMIT);
        Object displayDelay = json2.get(DISPLAY_DELAY);
        if (displayLimit instanceof Integer) {
            this.displayLimit = ((Number)displayLimit).intValue();
        }
        if (displayDelay instanceof Long) {
            this.displayDelay = ((Number)displayDelay).longValue();
        } else if (displayDelay instanceof Integer) {
            this.displayDelay = ((Number)displayDelay).intValue();
        }
    }

    public final void setDisplayStats(@NotNull InAppMessageRedisplayStats displayStats) {
        Intrinsics.checkNotNullParameter((Object)displayStats, (String)"displayStats");
        this.lastDisplayTime = displayStats.lastDisplayTime;
        this.displayQuantity = displayStats.displayQuantity;
    }

    public final void incrementDisplayQuantity() {
        int n = this.displayQuantity;
        this.displayQuantity = n + 1;
    }

    public final boolean shouldDisplayAgain() {
        boolean result = this.displayQuantity < this.displayLimit;
        Logging.debug$default((String)("OSInAppMessage shouldDisplayAgain: " + result), null, (int)2, null);
        return result;
    }

    public final boolean isDelayTimeSatisfied() {
        if (this.lastDisplayTime < 0L) {
            return true;
        }
        long currentTimeInSeconds = this._time.getCurrentTimeMillis() / (long)1000;
        long diffInSeconds = currentTimeInSeconds - this.lastDisplayTime;
        Logging.debug$default((String)("OSInAppMessage lastDisplayTime: " + this.lastDisplayTime + " currentTimeInSeconds: " + currentTimeInSeconds + " diffInSeconds: " + diffInSeconds + " displayDelay: " + this.displayDelay), null, (int)2, null);
        return diffInSeconds >= this.displayDelay;
    }

    @NotNull
    public final JSONObject toJSONObject() {
        JSONObject json2 = new JSONObject();
        try {
            json2.put(DISPLAY_LIMIT, this.displayLimit);
            json2.put(DISPLAY_DELAY, this.displayDelay);
        }
        catch (JSONException exception) {
            exception.printStackTrace();
        }
        return json2;
    }

    @NotNull
    public String toString() {
        return "OSInAppMessageDisplayStats{lastDisplayTime=" + this.lastDisplayTime + ", displayQuantity=" + this.displayQuantity + ", displayLimit=" + this.displayLimit + ", displayDelay=" + this.displayDelay + '}';
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/onesignal/inAppMessages/internal/InAppMessageRedisplayStats$Companion;", "", "()V", "DISPLAY_DELAY", "", "DISPLAY_LIMIT", "com.onesignal.inAppMessages"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

