/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.location.internal.common;

import android.content.Context;
import androidx.core.content.ContextCompat;
import com.google.android.gms.location.LocationListener;
import com.huawei.hms.location.LocationCallback;
import com.onesignal.common.AndroidUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/onesignal/location/internal/common/LocationUtils;", "", "()V", "hasGMSLocationLibrary", "", "hasHMSLocationLibrary", "hasLocationPermission", "context", "Landroid/content/Context;", "com.onesignal.location"})
public final class LocationUtils {
    @NotNull
    public static final LocationUtils INSTANCE = new LocationUtils();

    private LocationUtils() {
    }

    public final boolean hasGMSLocationLibrary() {
        boolean bl;
        try {
            bl = AndroidUtils.INSTANCE.opaqueHasClass(LocationListener.class);
        }
        catch (NoClassDefFoundError e) {
            bl = false;
        }
        return bl;
    }

    public final boolean hasHMSLocationLibrary() {
        boolean bl;
        try {
            bl = AndroidUtils.INSTANCE.opaqueHasClass(LocationCallback.class);
        }
        catch (NoClassDefFoundError e) {
            bl = false;
        }
        return bl;
    }

    public final boolean hasLocationPermission(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0 || ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0;
    }
}

