/*
 * Decompiled with CFR 0.152.
 */
package com.ongres.stringprep.codegenerator.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParserUtil {
    public List<Integer> parseToListInteger(String file, Pattern pattern) throws NumberFormatException, IOException {
        InputStream inputStream = ParserUtil.class.getResourceAsStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charset.defaultCharset()));
        String line = null;
        ArrayList<Integer> codePoints = new ArrayList<Integer>();
        while (null != (line = bufferedReader.readLine())) {
            Matcher matcherLine = pattern.matcher(line);
            if (!matcherLine.matches()) continue;
            String mappedFrom = matcherLine.group(1).replaceAll("\\s", "");
            codePoints.add(Integer.parseInt(mappedFrom, 16));
        }
        return codePoints;
    }

    public Map<Integer, List<Integer>> parseToMapListInteger(String file, Pattern patternLine, Pattern mapTo) throws IOException {
        InputStream inputStream = ParserUtil.class.getResourceAsStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charset.defaultCharset()));
        String line = null;
        HashMap<Integer, List<Integer>> mapWithNoNormalization = new HashMap<Integer, List<Integer>>();
        while (null != (line = bufferedReader.readLine())) {
            ArrayList<Integer> codePoints = new ArrayList<Integer>();
            Matcher matcherLine = patternLine.matcher(line);
            if (!matcherLine.matches()) continue;
            String mappedFrom = matcherLine.group(1);
            String mappedTo = matcherLine.group(2);
            Matcher matcherCodePoints = mapTo.matcher(mappedTo);
            while (matcherCodePoints.find()) {
                codePoints.add(Integer.parseInt(matcherCodePoints.group(1), 16));
            }
            String mapped = mappedFrom.replaceAll("\\s", "");
            mapWithNoNormalization.put(Integer.parseInt(mapped, 16), codePoints);
        }
        return mapWithNoNormalization;
    }

    public List<List<Integer>> parseToListArrayInt(String file) throws NumberFormatException, IOException {
        return this.parseToListArrayInt(file, null);
    }

    public List<List<Integer>> parseToListArrayInt(String file, Pattern pattern) throws NumberFormatException, IOException {
        InputStream inputStream = ParserUtil.class.getResourceAsStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charset.defaultCharset()));
        String line = null;
        ArrayList<List<Integer>> codePoints = new ArrayList<List<Integer>>();
        if (null != pattern) {
            while (null != (line = bufferedReader.readLine())) {
                Matcher matcherLine = pattern.matcher(line);
                if (!matcherLine.matches()) continue;
                this.fillList(codePoints, matcherLine.group(1).replaceAll("\\s", ""));
            }
        } else {
            while (null != (line = bufferedReader.readLine())) {
                this.fillList(codePoints, line.replaceAll("\\s", ""));
            }
        }
        return codePoints;
    }

    private void fillList(List<List<Integer>> codePoints, String value) {
        ArrayList<Integer> characters = new ArrayList<Integer>();
        if (value.contains("-")) {
            int separator = value.indexOf(45);
            characters.add(Integer.parseInt(value.substring(0, separator), 16));
            characters.add(Integer.parseInt(value.substring(separator + 1), 16));
        } else {
            characters.add(Integer.parseInt(value, 16));
            characters.add(Integer.parseInt(value, 16));
        }
        codePoints.add(characters);
    }
}

