/*
 * Decompiled with CFR 0.152.
 */
package com.onixbyte.simplejwt;

import com.onixbyte.simplejwt.exceptions.WeakSecretException;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecretCreator {
    private static final Logger log = LoggerFactory.getLogger(SecretCreator.class);
    private static final String LOWERCASE_CHARACTERS = "abcdefghijklmnopqrstuvwxyz";
    private static final String UPPERCASE_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String DIGITS = "0123456789";
    private static final String SPECIAL_SIGNS = "!@#$%^&,*()_+-=,[]{}|;:,'\",.<>/?";

    public static String createSecret(int length, boolean isContainCapital, boolean isContainDigital, boolean isContainSpecialSign) {
        if (length < 32) {
            throw new WeakSecretException("The requested secret, which is only %d characters long, is too weak. Please replace it with a stronger secret.".formatted(length));
        }
        Random randomiser = new Random();
        StringBuilder charset = new StringBuilder(LOWERCASE_CHARACTERS);
        if (isContainCapital) {
            charset.append(UPPERCASE_CHARACTERS);
        }
        if (isContainDigital) {
            charset.append(DIGITS);
        }
        if (isContainSpecialSign) {
            charset.append(SPECIAL_SIGNS);
        }
        StringBuilder secretBuilder = new StringBuilder();
        int charsetSize = charset.length();
        for (int i = 0; i < length; ++i) {
            secretBuilder.append(charset.charAt(randomiser.nextInt(charsetSize)));
        }
        return secretBuilder.toString();
    }

    public static String createSecret(int length, boolean isContainCapital, boolean isContainDigital) {
        return SecretCreator.createSecret(length, isContainCapital, isContainDigital, false);
    }

    public static String createSecret(int length, boolean isContainCapital) {
        return SecretCreator.createSecret(length, isContainCapital, false, false);
    }

    public static String createSecret(int length) {
        return SecretCreator.createSecret(length, false, false, false);
    }

    private SecretCreator() {
    }
}

