/*
 * Decompiled with CFR 0.152.
 */
package com.onixbyte.simplejwt.autoconfiguration;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.onixbyte.guid.GuidCreator;
import com.onixbyte.simplejwt.TokenResolver;
import com.onixbyte.simplejwt.authzero.AuthzeroTokenResolver;
import com.onixbyte.simplejwt.autoconfiguration.GuidAutoConfiguration;
import com.onixbyte.simplejwt.autoconfiguration.properties.SimpleJwtProperties;
import com.onixbyte.simplejwt.constants.TokenAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={SimpleJwtProperties.class})
@ConditionalOnClass(value={DecodedJWT.class, AuthzeroTokenResolver.class})
@ConditionalOnMissingBean(value={TokenResolver.class})
@ConditionalOnBean(value={GuidCreator.class}, name={"jtiCreator"})
@AutoConfigureAfter(value={GuidAutoConfiguration.class})
public class AuthzeroTokenResolverAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AuthzeroTokenResolverAutoConfiguration.class);
    private final GuidCreator<?> jtiCreator;
    private final SimpleJwtProperties simpleJwtProperties;
    private final ObjectMapper objectMapper;

    @Autowired
    public AuthzeroTokenResolverAutoConfiguration(SimpleJwtProperties simpleJwtProperties, @Qualifier(value="jtiCreator") GuidCreator<?> jtiCreator, ObjectMapper objectMapper) {
        this.jtiCreator = jtiCreator;
        this.simpleJwtProperties = simpleJwtProperties;
        this.objectMapper = objectMapper;
    }

    @Bean
    public TokenResolver<DecodedJWT> tokenResolver() {
        AuthzeroTokenResolver.Builder builder = AuthzeroTokenResolver.builder();
        if (TokenAlgorithm.ECDSA_ALGORITHMS.contains(this.simpleJwtProperties.getAlgorithm())) {
            builder.keyPair(this.simpleJwtProperties.getPublicKey(), this.simpleJwtProperties.getPrivateKey()).algorithm(this.simpleJwtProperties.getAlgorithm());
        } else if (TokenAlgorithm.HMAC_ALGORITHMS.contains(this.simpleJwtProperties.getAlgorithm())) {
            builder.secret(this.simpleJwtProperties.getSecret()).algorithm(this.simpleJwtProperties.getAlgorithm());
        }
        builder.issuer(this.simpleJwtProperties.getIssuer());
        builder.jtiCreator(this.jtiCreator);
        builder.objectMapper(this.objectMapper);
        return builder.build();
    }
}

