/*
 * Decompiled with CFR 0.152.
 */
package com.onixbyte.simplejwt.autoconfiguration.conditions;

import com.onixbyte.guid.GuidCreator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class GuidCreatorCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(GuidCreatorCondition.class);

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConfigurableListableBeanFactory beanFactory = Objects.requireNonNull(context.getBeanFactory());
        boolean isContainJtiCreator = beanFactory.containsBean("jtiCreator");
        if (isContainJtiCreator) {
            return !(beanFactory.getBean("jtiCreator") instanceof GuidCreator);
        }
        return true;
    }
}

