/*
 * Decompiled with CFR 0.152.
 */
package org.aml.apimodel;

import java.util.List;
import java.util.Optional;
import org.aml.apimodel.Action;
import org.aml.apimodel.Annotable;
import org.aml.apimodel.Api;
import org.aml.apimodel.IHasResources;
import org.aml.apimodel.INamedParam;

public interface Resource
extends Annotable,
Comparable<Resource>,
IHasResources {
    public String relativeUri();

    public String displayName();

    @Override
    public List<Resource> resources();

    public Resource parentResource();

    public List<Action> methods();

    public String description();

    public List<? extends INamedParam> uriParameters();

    public String getUri();

    public Api getApi();

    @Override
    default public int compareTo(Resource o) {
        return this.relativeUri().compareTo(o.relativeUri());
    }

    default public Optional<? extends INamedParam> uriParameterOpt(String name) {
        return this.uriParameters().stream().filter(x -> x.getKey().equals(name)).findFirst();
    }

    default public INamedParam uriParameter(String name) {
        return this.uriParameterOpt(name).orElse(null);
    }

    default public Action method(String name) {
        return this.methods().stream().filter(x -> x.method().equals(name)).findFirst().orElse(null);
    }
}

