/*
 * Decompiled with CFR 0.152.
 */
package org.aml.apimodel.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.aml.apimodel.INamedParam;
import org.aml.apimodel.impl.AnnotableImpl;
import org.aml.typesystem.AbstractType;
import org.aml.typesystem.BuiltIns;
import org.aml.typesystem.TypeOps;
import org.aml.typesystem.beans.ISimpleFacet;
import org.aml.typesystem.meta.FacetRegistry;
import org.aml.typesystem.meta.TypeInformation;
import org.aml.typesystem.meta.facets.Default;
import org.aml.typesystem.meta.facets.Description;
import org.aml.typesystem.meta.facets.DisplayName;
import org.aml.typesystem.meta.facets.Example;
import org.aml.typesystem.meta.restrictions.Enum;
import org.aml.typesystem.meta.restrictions.Pattern;
import org.aml.typesystem.meta.restrictions.minmax.MaxLength;
import org.aml.typesystem.meta.restrictions.minmax.Maximum;
import org.aml.typesystem.meta.restrictions.minmax.MinLength;
import org.aml.typesystem.meta.restrictions.minmax.Minimum;

public class NamedParamImpl
extends AnnotableImpl
implements INamedParam {
    protected AbstractType type;
    protected boolean required;
    protected boolean repeat;
    protected String name;

    public NamedParamImpl(AbstractType type, boolean required, boolean repeat) {
        this.type = type;
        this.name = type.name();
        this.required = required;
    }

    public NamedParamImpl(String string, AbstractType type, boolean required, boolean repeat) {
        this.name = string;
        this.required = required;
        this.repeat = repeat;
        this.type = type;
    }

    public NamedParamImpl() {
        this.type = BuiltIns.STRING;
        this.name = "param";
    }

    @Override
    public List<String> getEnumeration() {
        if (this.type.oneMeta(Enum.class) != null) {
            return ((Enum)this.type.oneMeta(Enum.class)).value();
        }
        return null;
    }

    @Override
    public String description() {
        if (this.type.hasDirectMeta(Description.class)) {
            return (String)((Description)this.type.oneMeta(Description.class)).value();
        }
        return null;
    }

    @Override
    public String getExample() {
        if (this.type.hasDirectMeta(Example.class)) {
            return "" + ((Example)this.type.oneMeta(Example.class)).value();
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        if (this.type.hasDirectMeta(DisplayName.class)) {
            return "" + (String)((DisplayName)this.type.oneMeta(DisplayName.class)).value();
        }
        return null;
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public String getDefaultValue() {
        Default oneMeta = (Default)this.type.oneMeta(Default.class);
        if (oneMeta != null) {
            return "" + oneMeta.value();
        }
        return null;
    }

    @Override
    public String getPattern() {
        Pattern oneMeta = (Pattern)this.type.oneMeta(Pattern.class);
        if (oneMeta != null) {
            return oneMeta.value();
        }
        return null;
    }

    @Override
    public Integer getMinLength() {
        MinLength oneMeta = (MinLength)this.type.oneMeta(MinLength.class);
        if (oneMeta != null) {
            return Integer.parseInt("" + oneMeta.value());
        }
        return null;
    }

    @Override
    public Integer getMaxLength() {
        MaxLength oneMeta = (MaxLength)this.type.oneMeta(MaxLength.class);
        if (oneMeta != null) {
            return Integer.parseInt("" + oneMeta.value());
        }
        return null;
    }

    @Override
    public BigDecimal getMinimum() {
        Minimum oneMeta = (Minimum)this.type.oneMeta(Minimum.class);
        if (oneMeta != null) {
            return new BigDecimal("" + oneMeta.value());
        }
        return null;
    }

    @Override
    public BigDecimal getMaximum() {
        Maximum oneMeta = (Maximum)this.type.oneMeta(Maximum.class);
        if (oneMeta != null) {
            return new BigDecimal("" + oneMeta.value());
        }
        return null;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isRepeat() {
        return this.repeat;
    }

    @Override
    public INamedParam.TypeKind getTypeKind() {
        if (this.type.isBoolean()) {
            return INamedParam.TypeKind.BOOLEAN;
        }
        if (this.type.isFile()) {
            return INamedParam.TypeKind.FILE;
        }
        if (this.type.isInteger()) {
            return INamedParam.TypeKind.INTEGER;
        }
        if (this.type.isNumber()) {
            return INamedParam.TypeKind.NUMBER;
        }
        if (this.type.isString()) {
            return INamedParam.TypeKind.STRING;
        }
        return INamedParam.TypeKind.STRING;
    }

    @Override
    public AbstractType getTypeModel() {
        return this.type;
    }

    public void setType(AbstractType integer) {
        this.type = integer;
    }

    public void setRequired(boolean b) {
        this.required = b;
    }

    public void setName(String paramName) {
        this.name = paramName;
    }

    public void setDescription(String text) {
        Class<Description> clazz = Description.class;
        this.setFacet(text, clazz);
    }

    public void setFacet(Object value, Class<? extends ISimpleFacet> clazz) {
        this.checkType();
        ISimpleFacet f = (ISimpleFacet)this.type.oneMeta(clazz);
        if (f == null) {
            f = (ISimpleFacet)FacetRegistry.facet((String)FacetRegistry.getFacetName(clazz));
            this.type.addMeta((TypeInformation)f);
        }
        f.setValue(value);
    }

    private void checkType() {
        if (this.type.isBuiltIn()) {
            this.type = TypeOps.derive((String)"", (AbstractType[])new AbstractType[]{this.type});
        }
    }

    public void setDefaultValue(String trim) {
        this.setFacet(trim, Default.class);
    }

    public void setMaximum(BigDecimal valueOf) {
        this.setFacet(valueOf.doubleValue(), Maximum.class);
    }

    public void setMinimum(BigDecimal valueOf) {
        this.setFacet(valueOf.doubleValue(), Minimum.class);
    }

    public void setPattern(String pattern) {
        this.setFacet(pattern, Pattern.class);
    }

    public void setRepeat(boolean boolValue) {
        this.repeat = true;
    }

    public void setEnumeration(ArrayList<String> list) {
        this.setFacet(list, Enum.class);
    }
}

