/*
 * Decompiled with CFR 0.152.
 */
package org.aml.apimodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.aml.apimodel.Action;
import org.aml.apimodel.Annotable;
import org.aml.apimodel.Api;
import org.aml.apimodel.IHasResources;
import org.aml.apimodel.INamedParam;
import org.aml.apimodel.ParameterLocation;
import org.aml.apimodel.impl.NamedParamImpl;
import org.aml.typesystem.AbstractType;
import org.aml.typesystem.BuiltIns;
import org.aml.typesystem.TypeOps;

public interface Resource
extends Annotable,
Comparable<Resource>,
IHasResources {
    public String relativeUri();

    public String displayName();

    @Override
    public List<Resource> resources();

    public Resource parentResource();

    public List<Action> methods();

    public String description();

    public List<? extends INamedParam> uriParameters();

    public String getUri();

    public Api getApi();

    @Override
    default public int compareTo(Resource o) {
        return this.relativeUri().compareTo(o.relativeUri());
    }

    default public Optional<? extends INamedParam> uriParameterOpt(String name) {
        return this.uriParameters().stream().filter(x -> x.getKey().equals(name)).findFirst();
    }

    default public INamedParam uriParameter(String name) {
        return this.uriParameterOpt(name).orElse(null);
    }

    default public List<INamedParam> allUriParameters() {
        String relativeUri = this.relativeUri();
        HashSet<String> pNames = new HashSet<String>();
        ArrayList<INamedParam> result = new ArrayList<INamedParam>();
        for (Resource r = this; r != null; r = r.parentResource()) {
            int end;
            int indexOf;
            while ((indexOf = relativeUri.indexOf(123)) != -1 && (end = relativeUri.indexOf(125, indexOf)) != -1) {
                String pName = relativeUri.substring(indexOf + 1, end);
                relativeUri = relativeUri.substring(end);
                pNames.add(pName);
            }
            for (String s : pNames) {
                boolean found = false;
                for (INamedParam p : result) {
                    if (!p.getKey().equals(s)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                NamedParamImpl namedParam = new NamedParamImpl(TypeOps.derive((String)s, (AbstractType[])new AbstractType[]{BuiltIns.STRING}), false, false);
                namedParam.setLocation(ParameterLocation.PATH);
                result.add(namedParam);
            }
        }
        Collections.reverse(result);
        return result;
    }

    default public Action method(String name) {
        return this.methods().stream().filter(x -> x.method().equals(name)).findFirst().orElse(null);
    }
}

