/*
 * Decompiled with CFR 0.152.
 */
package org.aml.apimodel.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.aml.apimodel.Api;
import org.aml.apimodel.DocumentationItem;
import org.aml.apimodel.Resource;
import org.aml.apimodel.SecuredByConfig;
import org.aml.apimodel.impl.ResourceImpl;
import org.aml.apimodel.impl.SecuredByConfigImpl;
import org.aml.apimodel.impl.TopLevelModelImpl;
import org.aml.typesystem.AbstractType;

public class ApiImpl
extends TopLevelModelImpl
implements Api {
    protected ArrayList<Resource> resources = new ArrayList();
    protected ArrayList<SecuredByConfig> securedBy = new ArrayList();
    protected List<DocumentationItem> documentation = new ArrayList<DocumentationItem>();
    protected List<String> protocols = new ArrayList<String>();
    protected List<String> mediaTypes = new ArrayList<String>();
    protected String description;
    protected String title;
    protected String baseUrl;
    protected String version;

    public List<DocumentationItem> getDocumentation() {
        return this.documentation;
    }

    public ArrayList<SecuredByConfig> getSecuredBy() {
        return this.securedBy;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String version() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    @Override
    public List<Resource> resources() {
        return this.resources;
    }

    public void addType(AbstractType t) {
        this.types.registerType(t);
    }

    public ResourceImpl getOrCreateResource(String path) {
        int p = path.indexOf(47);
        ResourceImpl rs = this.getOrCreateResourceWithSegment(path.substring(0, p != -1 ? p : path.length()));
        if (p != -1) {
            return rs.getOrCreateResource(path.substring(p + 1));
        }
        return rs;
    }

    private ResourceImpl getOrCreateResourceWithSegment(String string) {
        Optional<Resource> findFirst = this.resources.stream().filter(x -> x.relativeUri().equals("/" + string)).findFirst();
        return (ResourceImpl)findFirst.orElseGet(() -> {
            ResourceImpl resource = new ResourceImpl("/" + string);
            resource.api = this;
            this.resources.add(resource);
            return resource;
        });
    }

    @Override
    public String title() {
        return this.title;
    }

    public void addAnnotationType(AbstractType derive) {
        this.atypes.registerType(derive);
    }

    public void addSecuredBy(SecuredByConfigImpl securedByConfigImpl) {
        this.securedBy.add(securedByConfigImpl);
    }

    public void setDocumentation(List<DocumentationItem> arrayList) {
        this.documentation = arrayList;
    }

    @Override
    public List<DocumentationItem> documentation() {
        return this.documentation;
    }

    public void setProtocols(List<String> protocols) {
        this.protocols = protocols;
    }

    @Override
    public List<String> getProtocols() {
        return this.protocols;
    }

    @Override
    public List<String> getMediaType() {
        return this.mediaTypes;
    }

    public void setMediaTypes(List<String> mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public void setDescription(String service) {
        this.description = service;
    }

    @Override
    public String description() {
        return this.description;
    }
}

