/*
 * Decompiled with CFR 0.152.
 */
package org.aml.raml2java;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.aml.raml2java.ITypeGenerator;
import org.aml.raml2java.JavaWriter;
import org.aml.typesystem.AbstractType;
import org.aml.typesystem.BuiltIns;
import org.aml.typesystem.TypeOps;
import org.aml.typesystem.beans.IProperty;
import org.aml.typesystem.meta.facets.Default;
import org.aml.typesystem.meta.facets.Description;

public class AnnotationTypeGenerator
implements ITypeGenerator {
    protected JavaWriter owner;

    public AnnotationTypeGenerator(JavaWriter owner) {
        this.owner = owner;
    }

    @Override
    public JType define(AbstractType t) {
        if (t.isAnonimous()) {
            throw new IllegalStateException("Annotation types can not be anonimous");
        }
        if (!t.isObject()) {
            AbstractType wrapped = TypeOps.derive((String)t.name(), (AbstractType[])new AbstractType[]{BuiltIns.OBJECT});
            if (!t.isNill()) {
                wrapped.declareProperty("value", t.clone(""), false);
            }
            return this.define(wrapped);
        }
        if (t.isObject()) {
            JDefinedClass defineClass = this.owner.defineClass(t, ClassType.ANNOTATION_TYPE_DECL);
            JAnnotationUse annotate = defineClass.annotate(Retention.class);
            annotate.param("value", (Enum)RetentionPolicy.RUNTIME);
            t.toPropertiesView().allProperties().forEach(x -> {
                final JType type = this.owner.getType(x.range(), false, true, (IProperty)x);
                JMethod method = defineClass.method(1, type, this.owner.propNameGenerator.name((IProperty)x));
                AbstractType tp = x.range();
                if (tp.hasDirectMeta(Description.class)) {
                    method.javadoc().add(((Description)tp.oneMeta(Description.class)).value());
                }
                this.owner.annotate((JAnnotatable)method, x.range());
                Default oneMeta = (Default)x.range().oneMeta(Default.class);
                if (oneMeta != null) {
                    final Object value = oneMeta.value();
                    if (x.range().isEnumType()) {
                        method.declareDefaultValue((JExpression)new JExpressionImpl(){

                            public void generate(JFormatter f) {
                                f.p(type.name() + "." + value);
                            }
                        });
                    } else {
                        method.declareDefaultValue(this.owner.toExpr(value));
                    }
                } else if (!x.isRequired()) {
                    Object value = this.owner.getDefault(x.range());
                    method.declareDefaultValue(this.owner.toExpr(value));
                }
            });
            this.owner.annotate((JAnnotatable)defineClass, t);
            return defineClass;
        }
        return null;
    }
}

