/*
 * Decompiled with CFR 0.152.
 */
package org.aml.raml2java;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.gson.annotations.JsonAdapter;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import java.util.ArrayList;
import java.util.Set;
import org.aml.raml2java.ClassCustomizerParameters;
import org.aml.raml2java.GsonAcElementWriter;
import org.aml.raml2java.ITypeGenerator;
import org.aml.raml2java.JacksonDeserializerWriter;
import org.aml.raml2java.JacksonSerializerWriter;
import org.aml.raml2java.JavaWriter;
import org.aml.raml2java.PropertyCustomizerParameters;
import org.aml.raml2java.StringResourceFile;
import org.aml.typesystem.AbstractType;
import org.aml.typesystem.acbuilder.AcScheme;
import org.aml.typesystem.acbuilder.AcSchemeBuilder;

public class UnionTypeGenerator
implements ITypeGenerator {
    private JavaWriter writer;

    public UnionTypeGenerator(JavaWriter wr) {
        this.writer = wr;
    }

    @Override
    public JType define(AbstractType t) {
        String qName;
        String adapterName;
        String generateAdapter;
        AcScheme build;
        JDefinedClass defineClass = this.writer.defineClass(t, ClassType.CLASS);
        AcSchemeBuilder acSchemeBuilder = new AcSchemeBuilder();
        Set typeFamily = acSchemeBuilder.extendedUnionTypeFamily(t);
        for (AbstractType option : typeFamily) {
            this.generateProperty(defineClass, option, typeFamily);
        }
        this.writer.annotate((JAnnotatable)defineClass, t);
        if (this.writer.getConfig().isGsonSupport()) {
            build = acSchemeBuilder.build(t);
            generateAdapter = new GsonAcElementWriter().generateAdapter(defineClass.getPackage().name(), build, defineClass.name(), this.writer);
            adapterName = String.valueOf(defineClass.fullName()) + "Adapter";
            qName = String.valueOf(defineClass.name()) + "Adapter.java";
            this.writer.getModel()._package(defineClass.getPackage().name()).addResourceFile((JResourceFile)new StringResourceFile(qName, generateAdapter));
            defineClass.annotate(JsonAdapter.class).param("value", JExpr.dotclass((JClass)this.writer.getModel().directClass(adapterName)));
        }
        if (this.writer.getConfig().isJacksonSupport()) {
            build = acSchemeBuilder.build(t);
            generateAdapter = new JacksonDeserializerWriter().generateAdapter(defineClass.getPackage().name(), build, defineClass.name(), this.writer);
            adapterName = String.valueOf(defineClass.fullName()) + "Deserializer";
            qName = String.valueOf(defineClass.name()) + "Deserializer.java";
            this.writer.getModel()._package(defineClass.getPackage().name()).addResourceFile((JResourceFile)new StringResourceFile(qName, generateAdapter));
            defineClass.annotate(JsonDeserialize.class).param("using", JExpr.dotclass((JClass)this.writer.getModel().directClass(adapterName)));
            String writerCode = new JacksonSerializerWriter().generateAdapter(defineClass.getPackage().name(), build, defineClass.name(), this.writer);
            adapterName = String.valueOf(defineClass.fullName()) + "Serializer";
            qName = String.valueOf(defineClass.name()) + "Serializer.java";
            this.writer.getModel()._package(defineClass.getPackage().name()).addResourceFile((JResourceFile)new StringResourceFile(qName, writerCode));
            defineClass.annotate(JsonSerialize.class).param("using", JExpr.dotclass((JClass)this.writer.getModel().directClass(adapterName)));
        }
        this.writer.runCustomizers(new ClassCustomizerParameters(this.writer, defineClass, t, new ArrayList<PropertyCustomizerParameters>()));
        return defineClass;
    }

    private void generateProperty(JDefinedClass defineClass, final AbstractType option, final Set<AbstractType> allOptions) {
        String oname = option.name();
        String gset = JavaWriter.escape(oname);
        final String name = JavaWriter.escape(oname.toLowerCase());
        JType propType = this.writer.getType(option, false, false, null);
        if (propType.isPrimitive()) {
            propType = propType.boxify();
        }
        defineClass.field(4, propType, name);
        JMethod get = defineClass.method(1, propType, "get" + Character.toUpperCase(gset.charAt(0)) + gset.substring(1));
        get.body()._return((JExpression)JExpr.ref((String)name));
        this.writer.annotate((JAnnotatable)get, option);
        JMethod set = defineClass.method(1, this.writer.getModel()._ref(Void.TYPE), String.valueOf(option.isBoolean() ? "is" : "set") + Character.toUpperCase(gset.charAt(0)) + gset.substring(1));
        set.param(propType, "value");
        set.body().add(new JStatement(){

            public void state(JFormatter f) {
                f.p("this." + name + "=value;");
                f.nl();
                for (AbstractType other : allOptions) {
                    if (other == option) continue;
                    String oname = other.name();
                    String name2 = JavaWriter.escape(oname.toLowerCase());
                    f.p("this." + name2 + "=null;");
                    f.nl();
                }
            }
        });
    }

    static /* synthetic */ JavaWriter access$0(UnionTypeGenerator unionTypeGenerator) {
        return unionTypeGenerator.writer;
    }
}

