/*
 * Decompiled with CFR 0.152.
 */
package org.aml.raml2java;

import java.util.HashSet;
import org.aml.raml2java.IAnnotationProcessingConfig;
import org.aml.typesystem.AbstractType;

public class BasicAnnotationProcessingConfig
implements IAnnotationProcessingConfig {
    protected HashSet<String> namespacesToSkipDefinition = new HashSet();
    protected HashSet<String> namespacesToSkipReference = new HashSet();
    protected HashSet<String> idsToSkipDefinition = new HashSet();
    protected HashSet<String> idsToSkipReference = new HashSet();
    protected boolean skipAllDefinitions;
    protected boolean skipAllReferences;

    public boolean isSkipAllReferences() {
        return this.skipAllReferences;
    }

    public void setSkipAllReferences(boolean skipAllReferences) {
        this.skipAllReferences = skipAllReferences;
    }

    public boolean isSkipAllDefinitions() {
        return this.skipAllDefinitions;
    }

    public void setSkipAllDefinitions(boolean skipAllDefinitions) {
        this.skipAllDefinitions = skipAllDefinitions;
    }

    public void addNamespaceToSkipReference(String namespace) {
        this.namespacesToSkipReference.add(namespace);
    }

    public void addNamespaceToSkipDefinition(String namespace) {
        this.namespacesToSkipDefinition.add(namespace);
    }

    public void addIdToSkipReference(String namespace) {
        this.idsToSkipReference.add(namespace);
    }

    public void addIdToSkipDefinition(String namespace) {
        this.idsToSkipDefinition.add(namespace);
    }

    @Override
    public boolean skipDefinition(AbstractType t) {
        if (this.skipAllDefinitions) {
            return true;
        }
        String nm = t.getNameSpaceId();
        if (this.namespacesToSkipDefinition.contains(nm)) {
            return true;
        }
        String id = String.valueOf(nm) + "." + t.name();
        return this.idsToSkipDefinition.contains(id);
    }

    @Override
    public boolean skipReference(AbstractType t) {
        if (this.skipAllReferences) {
            return true;
        }
        String nm = t.getNameSpaceId();
        if (this.namespacesToSkipReference.contains(nm)) {
            return true;
        }
        String id = String.valueOf(nm) + "." + t.name();
        return this.idsToSkipReference.contains(id);
    }
}

