/*
 * Decompiled with CFR 0.152.
 */
package org.aml.raml2java;

import java.util.HashSet;
import org.aml.java.mapping.javaName;
import org.aml.raml2java.INameGenerator;
import org.aml.raml2java.JavaWriter;
import org.aml.typesystem.AbstractType;
import org.aml.typesystem.IAnnotation;
import org.aml.typesystem.meta.TypeInformation;
import org.aml.typesystem.meta.facets.Annotation;

public class DefaultNameGenerator
implements INameGenerator {
    private static final String AML_NAMESPACE = "org.aml.java.mapping";
    protected String defaultPackageName;
    protected HashSet<String> used = new HashSet();
    static String[] keywords = new String[]{"package", "class", "interface", "private", "public", "protected", "volatile", "for", "while", "do", "break", "continue", "if", "synhronized", "trasient", "implements", "extends", "enum", "goto", "static", "boolean", "int", "double", "float", "long", "short", "null", "byte", "char"};
    static HashSet<String> ks = new HashSet();

    static {
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            ks.add(s);
            ++n2;
        }
    }

    public static boolean isKeyword(String v) {
        return ks.contains(v);
    }

    public DefaultNameGenerator(String string) {
        this.defaultPackageName = string;
    }

    @Override
    public String fullyQualifiedName(AbstractType t) {
        String name = t.name();
        name = JavaWriter.escape(name);
        javaName annotation = (javaName)t.annotation(javaName.class, false);
        if (annotation != null) {
            name = annotation.value();
        }
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (name.equals(s)) {
                name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
            }
            ++n2;
        }
        String defaultPackageName2 = this.defaultPackageName;
        if (t.getSource() != null) {
            for (IAnnotation a : t.getSource().annotations()) {
                if (!a.annotationType().name().equals("package") || !a.annotationType().getNameSpaceId().equals(AML_NAMESPACE)) continue;
                defaultPackageName2 = "" + a.value();
            }
        }
        String string = String.valueOf(defaultPackageName2) + "." + name;
        for (TypeInformation x : t.meta()) {
            Annotation a;
            if (!(x instanceof Annotation) || !(a = (Annotation)x).annotationType().name().equals("package") || !a.annotationType().getNameSpaceId().equals(AML_NAMESPACE)) continue;
            string = a.value() + "." + name;
        }
        if (!this.used.add(string)) {
            int i = 2;
            while (i < Integer.MAX_VALUE) {
                string = String.valueOf(defaultPackageName2) + "." + name + i;
                if (this.used.add(string)) {
                    return string;
                }
                ++i;
            }
        }
        return string;
    }
}

