/*
 * Decompiled with CFR 0.152.
 */
package org.aml.raml2java;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.aml.raml2java.ClassCustomizerParameters;
import org.aml.raml2java.IClassCustomizer;
import org.aml.raml2java.JavaWriter;
import org.aml.raml2java.PropertyCustomizerParameters;
import org.aml.typesystem.AbstractType;
import org.aml.typesystem.beans.ISimpleFacet;
import org.aml.typesystem.java.AnnotationsProcessingConfig;
import org.aml.typesystem.meta.TypeInformation;
import org.aml.typesystem.meta.facets.Annotation;
import org.aml.typesystem.meta.facets.CustomFacet;

public class FacetProcessingConfig
implements IClassCustomizer {
    protected HashMap<String, AnnotationGenerationInfo> configs = new HashMap();
    protected JavaWriter writer;

    public FacetProcessingConfig() {
        AnnotationsProcessingConfig annotationsProcessingConfig = new AnnotationsProcessingConfig();
        annotationsProcessingConfig.append(AnnotationsProcessingConfig.class.getResourceAsStream("/javax.validation.xml"));
        this.appendConfig(annotationsProcessingConfig);
    }

    public void clear() {
        this.configs.clear();
    }

    public void appendConfig(AnnotationsProcessingConfig annotationsProcessingConfig) {
        for (AnnotationsProcessingConfig.AnnotationConfig v : annotationsProcessingConfig.getConfiguration()) {
            for (AnnotationsProcessingConfig.MemberMapping m : v.members) {
                String target = String.valueOf(m.type) + "." + m.target;
                AnnotationGenerationInfo i = new AnnotationGenerationInfo();
                i.annotationClassName = v.name;
                i.annotationMemberName = m.name;
                i.value = m.value;
                this.configs.put(target, i);
            }
        }
    }

    void processFacets(AbstractType t, PropertyCustomizerParameters cp) {
        if (t.isUnion()) {
            return;
        }
        HashSet<String> names = new HashSet<String>();
        for (AbstractType q : t.allSuperTypes()) {
            names.add(q.name());
        }
        Set meta = t.meta();
        ArrayList arrayList = new ArrayList(meta);
        if (cp.prop.isRequired()) {
            meta.add(new CustomFacet("required", (Object)true));
        }
        for (TypeInformation i : arrayList) {
            ISimpleFacet si;
            if (!(i instanceof ISimpleFacet) || (si = (ISimpleFacet)i) instanceof Annotation) continue;
            String facetName = si.facetName();
            for (String m : names) {
                String fullName = String.valueOf(m) + "." + facetName;
                AnnotationGenerationInfo annotationGenerationInfo = this.configs.get(fullName);
                if (annotationGenerationInfo == null) continue;
                this.processConfig(annotationGenerationInfo, si, cp);
            }
        }
    }

    protected void processConfig(AnnotationGenerationInfo annotationGenerationInfo, ISimpleFacet si, PropertyCustomizerParameters cp) {
        JMethod annotable = cp.getter;
        JAnnotationUse use = null;
        for (JAnnotationUse u : annotable.annotations()) {
            if (!u.getAnnotationClass().fullName().equals(annotationGenerationInfo.annotationClassName)) continue;
            use = u;
            break;
        }
        if (use == null) {
            use = annotable.annotate(this.writer.getModel().ref(annotationGenerationInfo.annotationClassName));
        }
        this.writer.addParam(use, si.value(), annotationGenerationInfo.annotationMemberName);
    }

    @Override
    public void customize(ClassCustomizerParameters parameters) {
        this.writer = parameters.writer;
        for (PropertyCustomizerParameters a : parameters.props) {
            this.processFacets(a.prop.range(), a);
        }
    }

    public static class AnnotationGenerationInfo {
        protected String sourceFacetType;
        protected String sourceFacet;
        protected String annotationClassName;
        protected Object value;
        protected String annotationMemberName;
    }
}

