/*
 * Decompiled with CFR 0.152.
 */
package org.aml.raml2java;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JStatement;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.aml.raml2java.JavaWriter;
import org.aml.typesystem.AbstractType;
import org.aml.typesystem.acbuilder.AcScheme;
import org.raml.v2.internal.utils.StreamUtils;

public abstract class GenericAcAdapterWriter {
    protected String template;

    public GenericAcAdapterWriter(String templatePath) {
        this.template = StreamUtils.toString((InputStream)GenericAcAdapterWriter.class.getResourceAsStream(templatePath));
    }

    public String generateAdapter(String packageName, AcScheme scheme, String targetName, JavaWriter writer) {
        String template = this.template.replace("{typeName}", targetName);
        template = template.replace("{packageName}", packageName);
        template = this.doReader(scheme, writer, template);
        template = this.doWriter(scheme, writer, template);
        return template;
    }

    private String doReader(AcScheme scheme, JavaWriter writer, String template) {
        JBlock bl = this.generateAc(scheme, writer);
        StringWriter w = new StringWriter();
        JFormatter f = new JFormatter((Writer)w);
        int i = 0;
        while (i < 4) {
            f.i();
            ++i;
        }
        bl.generate(f);
        template = template.replace("{acCode}", w.toString());
        return template;
    }

    protected String doWriter(AcScheme scheme, JavaWriter writer, String template) {
        JBlock wr = this.generateWriter(scheme, writer);
        StringWriter w = new StringWriter();
        JFormatter f = new JFormatter((Writer)w);
        int i = 0;
        while (i < 4) {
            f.i();
            ++i;
        }
        wr.generate(f);
        template = template.replace("{writeCode}", w.toString());
        return template;
    }

    protected JBlock generateWriter(AcScheme scheme, JavaWriter writer) {
        JBlock bl = new JBlock();
        for (AbstractType tp : scheme.getSchemes().keySet()) {
            String name = this.getName(tp, writer);
            final String ge = "value.get" + Character.toUpperCase(name.charAt(0)) + name.substring(1) + "()";
            JBlock th = bl._if(JExpr.direct((String)(String.valueOf(ge) + "!=null")))._then();
            th.add(new JStatement(){

                public void state(JFormatter f) {
                    f.p("gson.toJson(" + ge + "," + ge + ".getClass(), out);");
                    f.nl();
                }
            });
        }
        return bl;
    }

    protected String getName(AbstractType target, JavaWriter writer) {
        return target.name();
    }

    protected String getJavaTypeName(AbstractType target, JavaWriter writer) {
        return writer.getType(target).name();
    }

    protected abstract JBlock generateAc(AcScheme var1, JavaWriter var2);
}

