/*
 * Decompiled with CFR 0.152.
 */
package org.aml.java2ramlMaven;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aml.raml2java.IClassCustomizer;
import org.aml.raml2java.IPropertyCustomizer;
import org.aml.raml2java.JavaGenerationConfig;
import org.aml.raml2java.JavaWriter;
import org.aml.typesystem.ITypeLibrary;
import org.aml.typesystem.ramlreader.TopLevelRamlImpl;
import org.aml.typesystem.ramlreader.TopLevelRamlModelBuilder;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.dependency.fromDependencies.AbstractDependencyFilterMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.raml.v2.api.loader.FileResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;

@Mojo(name="generateJava", requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class Raml2JavaMojo
extends AbstractDependencyFilterMojo {
    @Parameter(property="outputFolder", defaultValue="./generated-sources/main/java")
    private File outputFolder;
    @Parameter
    protected List<File> ramlFiles;
    @Parameter
    protected String defaultPackageName = "org.aml.samples";
    @Parameter
    protected boolean gsonSupport = false;
    @Parameter(defaultValue="true")
    protected boolean jacksonSupport = true;
    @Parameter(defaultValue="true")
    protected boolean jaxbSupport = true;
    @Parameter
    protected boolean containerStrategyCollection = true;
    protected ArrayList<IPropertyCustomizer> customizers = new ArrayList();
    protected ArrayList<IClassCustomizer> classCustomizers = new ArrayList();
    @Parameter
    protected JavaGenerationConfig.WrappersStrategy wrappedTypesStrategy = JavaGenerationConfig.WrappersStrategy.NONE;
    @Parameter
    protected boolean addGenerated = true;
    @Parameter
    protected HashSet<String> annotationNamespacesToSkipDefinition = new HashSet();
    @Parameter
    protected HashSet<String> annotationNamespacesToSkipReference = new HashSet();
    @Parameter
    protected HashSet<String> annotationIdsToSkipDefinition = new HashSet();
    @Parameter
    protected HashSet<String> annotationIdsToSkipReference = new HashSet();
    @Parameter
    protected boolean skipAllAnnotationDefinitions;
    @Parameter
    protected boolean skipAllAnnotationReferences;
    @Parameter
    protected JavaGenerationConfig.DefaultIntegerFormat integerFormat = JavaGenerationConfig.DefaultIntegerFormat.INT;
    @Parameter
    protected JavaGenerationConfig.DefaultNumberFormat doubleFormat = JavaGenerationConfig.DefaultNumberFormat.DOUBLE;
    @Parameter
    protected boolean hashCodeAndEquals;
    @Parameter
    protected boolean implementSerializable;
    @Parameter
    protected boolean implementClonable;
    @Parameter
    protected boolean generateBuilderMethods = true;
    @Parameter
    protected boolean includeJsr303Annotations = true;

    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (!this.outputFolder.exists()) {
            this.outputFolder.mkdirs();
        }
        for (File f : this.ramlFiles) {
            try {
                TopLevelRamlImpl build = new TopLevelRamlModelBuilder().build((InputStream)new BufferedInputStream(new FileInputStream(f)), (ResourceLoader)new FileResourceLoader(f.getParentFile()), f.getName());
                JavaWriter wr = new JavaWriter();
                wr.getConfig().setWrapperStrategy(this.wrappedTypesStrategy);
                wr.getConfig().getAnnotationConfig().setSkipAllDefinitions(this.skipAllAnnotationDefinitions);
                wr.getConfig().getAnnotationConfig().setSkipAllReferences(this.skipAllAnnotationReferences);
                if (this.annotationIdsToSkipDefinition != null) {
                    for (String s : this.annotationIdsToSkipDefinition) {
                        wr.getConfig().getAnnotationConfig().addIdToSkipDefinition(s);
                    }
                }
                if (this.annotationIdsToSkipReference != null) {
                    for (String s : this.annotationIdsToSkipReference) {
                        wr.getConfig().getAnnotationConfig().addIdToSkipReference(s);
                    }
                }
                if (this.annotationNamespacesToSkipDefinition != null) {
                    for (String s : this.annotationNamespacesToSkipDefinition) {
                        wr.getConfig().getAnnotationConfig().addNamespaceToSkipDefinition(s);
                    }
                }
                if (this.annotationNamespacesToSkipReference != null) {
                    for (String s : this.annotationNamespacesToSkipReference) {
                        wr.getConfig().getAnnotationConfig().addNamespaceToSkipReference(s);
                    }
                }
                wr.getConfig().setJacksonSupport(this.jacksonSupport);
                wr.getConfig().setGsonSupport(this.gsonSupport);
                wr.getConfig().setJaxbSupport(this.jaxbSupport);
                wr.getConfig().setContainerStrategyCollection(this.containerStrategyCollection);
                wr.getConfig().setMultipleInheritanceStrategy(JavaGenerationConfig.MultipleInheritanceStrategy.MIX_IN);
                wr.setDefaultPackageName(this.defaultPackageName);
                wr.getConfig().setIntegerFormat(this.integerFormat);
                wr.getConfig().setDoubleFormat(this.doubleFormat);
                wr.getConfig().setAddGenerated(this.addGenerated);
                wr.getConfig().setGenerateHashCodeAndEquals(this.hashCodeAndEquals);
                wr.getConfig().setImplementSerializable(this.implementSerializable);
                wr.getConfig().setImplementClonable(this.implementClonable);
                wr.getConfig().setGenerateBuilderMethods(this.generateBuilderMethods);
                wr.getConfig().setIncludeJsr303Annotations(this.includeJsr303Annotations);
                wr.write((ITypeLibrary)build);
                wr.getModel().build(this.outputFolder);
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException(e.getMessage());
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new ArtifactsFilter(){

            public boolean isArtifactIncluded(Artifact artifact) throws ArtifactFilterException {
                return true;
            }

            public Set filter(Set artifacts) throws ArtifactFilterException {
                return artifacts;
            }
        };
    }
}

