/*
 * Decompiled with CFR 0.152.
 */
package com.openelements.hedera.base;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Hbar;
import com.openelements.hedera.base.Account;
import com.openelements.hedera.base.HederaException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public interface AccountClient {
    @NonNull
    default public Account createAccount() throws HederaException {
        return this.createAccount(Hbar.ZERO);
    }

    @NonNull
    public Account createAccount(@NonNull Hbar var1) throws HederaException;

    @NonNull
    default public Account createAccount(long initialBalanceInHbar) throws HederaException {
        if (initialBalanceInHbar < 0L) {
            throw new IllegalArgumentException("initialBalanceInHbar must be non-negative");
        }
        return this.createAccount(Hbar.from((long)initialBalanceInHbar));
    }

    public void deleteAccount(@NonNull AccountId var1) throws HederaException;

    default public void deleteAccount(@NonNull String accountId) throws HederaException {
        Objects.requireNonNull(accountId, "accountId must not be null");
        this.deleteAccount(AccountId.fromString((String)accountId));
    }

    @NonNull
    public Hbar getAccountBalance(@NonNull AccountId var1) throws HederaException;

    @NonNull
    default public Hbar getAccountBalance(@NonNull String accountId) throws HederaException {
        Objects.requireNonNull(accountId, "accountId must not be null");
        return this.getAccountBalance(AccountId.fromString((String)accountId));
    }
}

